/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.utils;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.correomqtt.business.dispatcher.ApplicationLifecycleObserver;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.mqtt.CorreoMqttClient;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.business.services.DisconnectService;
import org.correomqtt.business.utils.CorreoMqttConnection;

public class ConnectionHolder
implements ApplicationLifecycleObserver {
    private static ConnectionHolder instance;
    private final Map<String, CorreoMqttConnection> connectionMap = new ConcurrentHashMap<String, CorreoMqttConnection>();

    private ConnectionHolder() {
    }

    public static synchronized ConnectionHolder getInstance() {
        if (instance == null) {
            instance = new ConnectionHolder();
            instance.refresh();
        }
        return instance;
    }

    public void refresh() {
        int sort = 0;
        HashSet<String> existingConnectionIds = new HashSet<String>(this.connectionMap.keySet());
        for (ConnectionConfigDTO c : SettingsProvider.getInstance().getConnectionConfigs()) {
            CorreoMqttConnection connection = this.connectionMap.get(c.getId());
            if (connection == null) {
                this.connectionMap.put(c.getId(), CorreoMqttConnection.builder().configDTO(c).sort(sort).build());
            } else {
                existingConnectionIds.remove(c.getId());
                connection.setConfigDTO(c);
                connection.setSort(sort);
            }
            ++sort;
        }
        existingConnectionIds.forEach(this.connectionMap::remove);
    }

    public CorreoMqttConnection getConnection(String connectionId) {
        return this.connectionMap.get(connectionId);
    }

    public CorreoMqttClient getClient(String connectionId) {
        CorreoMqttConnection clientConnection = this.connectionMap.get(connectionId);
        if (clientConnection == null) {
            return null;
        }
        return clientConnection.getClient();
    }

    public ConnectionConfigDTO getConfig(String connectionId) {
        CorreoMqttConnection clientConnection = this.connectionMap.get(connectionId);
        if (clientConnection == null) {
            return null;
        }
        return clientConnection.getConfigDTO();
    }

    public boolean isConnectionUnused(ConnectionConfigDTO config) {
        return this.getConnection(config.getId()).getClient() == null;
    }

    public Map<String, CorreoMqttConnection> getConnections() {
        return this.connectionMap;
    }

    @Override
    public void onShutdown() {
        this.connectionMap.keySet().forEach(connectionId -> new DisconnectService((String)connectionId).disconnect());
    }

    public List<ConnectionConfigDTO> getSortedConnections() {
        return this.connectionMap.values().stream().sorted(Comparator.comparing(CorreoMqttConnection::getSort)).map(CorreoMqttConnection::getConfigDTO).collect(Collectors.toList());
    }
}

