/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.utils;

import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.mqtt.CorreoMqttClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorreoMqttConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorreoMqttConnection.class);
    private int sort;
    private ConnectionConfigDTO configDTO;
    private CorreoMqttClient client;

    public CorreoMqttConnection(ConnectionConfigDTO configDTO, int sort) {
        this.sort = sort;
        this.configDTO = configDTO;
    }

    public static CorreoMqttConnectionBuilder builder() {
        return new CorreoMqttConnectionBuilder();
    }

    public int getSort() {
        return this.sort;
    }

    public ConnectionConfigDTO getConfigDTO() {
        return this.configDTO;
    }

    public CorreoMqttClient getClient() {
        return this.client;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public void setConfigDTO(ConnectionConfigDTO configDTO) {
        this.configDTO = configDTO;
    }

    public void setClient(CorreoMqttClient client) {
        this.client = client;
    }

    public CorreoMqttConnection(int sort, ConnectionConfigDTO configDTO, CorreoMqttClient client) {
        this.sort = sort;
        this.configDTO = configDTO;
        this.client = client;
    }

    public static class CorreoMqttConnectionBuilder {
        private int sort;
        private ConnectionConfigDTO configDTO;
        private CorreoMqttClient client;

        CorreoMqttConnectionBuilder() {
        }

        public CorreoMqttConnectionBuilder sort(int sort) {
            this.sort = sort;
            return this;
        }

        public CorreoMqttConnectionBuilder configDTO(ConnectionConfigDTO configDTO) {
            this.configDTO = configDTO;
            return this;
        }

        public CorreoMqttConnectionBuilder client(CorreoMqttClient client) {
            this.client = client;
            return this;
        }

        public CorreoMqttConnection build() {
            return new CorreoMqttConnection(this.sort, this.configDTO, this.client);
        }

        public String toString() {
            return "CorreoMqttConnection.CorreoMqttConnectionBuilder(sort=" + this.sort + ", configDTO=" + this.configDTO + ", client=" + this.client + ")";
        }
    }
}

