/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.controller.LoaderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseController.class);
    private static ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());

    BaseController() {
    }

    static <C extends BaseController, Z extends Class<C>> LoaderResult<C> load(Z controllerClazz, String fxml) {
        return BaseController.load(controllerClazz, fxml, () -> (BaseController)controllerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    static <C extends BaseController, Z extends Class<C>> LoaderResult<C> load(Z controllerClazz, String fxml, ConstructorMethod<C> constructorMethod) {
        Parent parent;
        FXMLLoader loader = new FXMLLoader(controllerClazz.getResource(fxml), ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale()));
        loader.setControllerFactory(param -> {
            try {
                return constructorMethod.construct();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Exception loading {} from {}: ", new Object[]{controllerClazz.getSimpleName(), fxml, e});
                throw new IllegalStateException(e);
            }
        });
        try {
            parent = (Parent)loader.load();
        }
        catch (IOException e) {
            LOGGER.error("Exception loading {} from {}", (Object)controllerClazz.getSimpleName(), (Object)fxml);
            throw new IllegalStateException(e);
        }
        return LoaderResult.builder().controller((BaseController)loader.getController()).mainPane((Pane)parent).resourceBundle(resources).build();
    }

    static <Z extends BaseController> void showAsDialog(LoaderResult<Z> result, String title, Map<Object, Object> windowProperties, boolean resizable, boolean alwaysOnTop, EventHandler<WindowEvent> closeHandler, EventHandler<KeyEvent> keyHandler) {
        Scene scene = new Scene((Parent)result.getMainPane());
        String cssPath = SettingsProvider.getInstance().getCssPath();
        if (cssPath != null) {
            scene.getStylesheets().add((Object)cssPath);
        }
        Stage stage = new Stage();
        stage.setTitle(title);
        stage.setScene(scene);
        stage.setResizable(resizable);
        stage.setAlwaysOnTop(alwaysOnTop);
        stage.show();
        if (closeHandler != null) {
            stage.getScene().getWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, closeHandler);
        }
        if (keyHandler != null) {
            stage.getScene().getWindow().addEventFilter(KeyEvent.KEY_PRESSED, keyHandler);
        }
        stage.getScene().getWindow().getProperties().putAll(windowProperties);
    }

    @FunctionalInterface
    public static interface ConstructorMethod<Z> {
        public Z construct() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;
    }
}

