/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.cell.ConnectionCell;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.ConnectionOnboardingDelegate;
import org.correomqtt.gui.controller.ConnectionSettingsViewController;
import org.correomqtt.gui.controller.ConnectionSettingsViewDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;
import org.correomqtt.gui.transformer.ConnectionTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionOnbordingViewController
extends BaseController
implements ConfigObserver,
ConnectionOnboardingDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionOnbordingViewController.class);
    @FXML
    public AnchorPane helloViewAnchor;
    @FXML
    public ComboBox<String> helloViewComboBox;
    @FXML
    public Button helloViewConnectButton;
    @FXML
    public Button editConnectionsButton;
    @FXML
    public HBox mainHBox;
    @FXML
    public Label noConnectionsLabel;
    @FXML
    public VBox helloViewVBox;
    @FXML
    public ListView<ConnectionPropertiesDTO> connectionListView;
    @FXML
    public HBox buttonBar;
    @FXML
    public HBox noConnectionsButtonBar;
    private ConnectionOnboardingDelegate connectionsOnboardingDelegate;
    private ConnectionSettingsViewDelegate connectionsSettingsViewDelegate;

    public ConnectionOnbordingViewController(ConnectionOnboardingDelegate connectionsOnboardingDelegate, ConnectionSettingsViewDelegate connectionSettingsViewDelegate) {
        this.connectionsOnboardingDelegate = connectionsOnboardingDelegate;
        this.connectionsSettingsViewDelegate = connectionSettingsViewDelegate;
        ConfigDispatcher.getInstance().addObserver(this);
    }

    public static LoaderResult<ConnectionOnbordingViewController> load(ConnectionOnboardingDelegate connectionsOnboardingDelegate, ConnectionSettingsViewDelegate connectionSettingsViewDelegate) {
        return ConnectionOnbordingViewController.load(ConnectionOnbordingViewController.class, "connectionOnboardingView.fxml", () -> new ConnectionOnbordingViewController(connectionsOnboardingDelegate, connectionSettingsViewDelegate));
    }

    public void setDelegate(ConnectionOnboardingDelegate delegate) {
        this.connectionsOnboardingDelegate = delegate;
    }

    @FXML
    public void initialize() {
        this.connectionListView.setCellFactory(this::createCell);
        this.connectionListView.setItems(FXCollections.observableArrayList(ConnectionTransformer.dtoListToPropList(ConnectionHolder.getInstance().getSortedConnections())));
        this.updateConnections();
        this.connectionListView.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.connect();
            }
        });
        this.connectionListView.requestFocus();
    }

    private ListCell<ConnectionPropertiesDTO> createCell(ListView<ConnectionPropertiesDTO> connectionConfigDTOListView) {
        ConnectionCell cell = new ConnectionCell(this.connectionListView);
        cell.setOnMouseClicked(event -> this.onCellClicked((MouseEvent)event, (ConnectionPropertiesDTO)cell.getItem()));
        return cell;
    }

    private void onCellClicked(MouseEvent event, ConnectionPropertiesDTO configDTO) {
        if (configDTO != null && event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
            this.connect();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Clicked on connect: {}", (Object)configDTO.getId());
            }
        }
    }

    private void updateConnections() {
        ArrayList resultList = new ArrayList(this.connectionListView.getItems());
        List<ConnectionPropertiesDTO> newConnectionList = ConnectionTransformer.dtoListToPropList(ConnectionHolder.getInstance().getSortedConnections());
        AtomicInteger sortIndex = new AtomicInteger();
        Map<String, Integer> sorted = newConnectionList.stream().collect(Collectors.toMap(i -> i.getId(), i -> sortIndex.getAndIncrement()));
        Map<String, ConnectionPropertiesDTO> oldConnections = resultList.stream().collect(Collectors.toMap(ConnectionPropertiesDTO::getId, i -> i));
        newConnectionList.forEach(connection -> {
            ConnectionPropertiesDTO connectionToUpdate = (ConnectionPropertiesDTO)oldConnections.get(connection.getId());
            if (connectionToUpdate != null) {
                connectionToUpdate.getNameProperty().setValue(connection.getName());
                connectionToUpdate.getUrlProperty().setValue(connection.getUrl());
                connectionToUpdate.getPortProperty().setValue((Number)connection.getPort());
                connectionToUpdate.getClientIdProperty().setValue(connection.getClientId());
                connectionToUpdate.getUsernameProperty().setValue(connection.getUsername());
                connectionToUpdate.getPasswordProperty().setValue(connection.getPassword());
                connectionToUpdate.getCleanSessionProperty().setValue(Boolean.valueOf(connection.isCleanSession()));
                connectionToUpdate.getMqttVersionProperty().setValue((Object)connection.getMqttVersion());
                connectionToUpdate.getSslProperty().setValue((Object)connection.getSsl());
                connectionToUpdate.getSslKeystoreProperty().setValue(connection.getSslKeystore());
                connectionToUpdate.getSslKeystorePasswordProperty().setValue(connection.getSslKeystorePassword());
                connectionToUpdate.getProxyProperty().setValue((Object)connection.getProxy());
                connectionToUpdate.getSshHostProperty().setValue(connection.getSshHost());
                connectionToUpdate.getSshPortProperty().setValue((Number)connection.getSshPort());
                connectionToUpdate.getLocalPortProperty().setValue((Number)connection.getLocalPort());
                connectionToUpdate.getAuthProperty().setValue((Object)connection.getAuth());
                connectionToUpdate.getAuthUsernameProperty().setValue(connection.getAuthUsername());
                connectionToUpdate.getAuthPasswordProperty().setValue(connection.getAuthPassword());
                connectionToUpdate.getAuthKeyfileProperty().setValue(connection.getAuthKeyfile());
                connectionToUpdate.getLwtProperty().setValue((Object)connection.getLwt());
                connectionToUpdate.getLwtTopicProperty().setValue(connection.getLwtTopic());
                connectionToUpdate.getLwtQoSProperty().setValue((Object)connection.getLwtQos());
                connectionToUpdate.getLwtRetainedProperty().setValue(Boolean.valueOf(connection.isLwtRetained()));
                connectionToUpdate.getLwtPayloadProperty().setValue(connection.getLwtPayload());
            } else {
                resultList.add(connection);
            }
        });
        ArrayList allConnectionsToDelete = new ArrayList();
        Map<String, ConnectionPropertiesDTO> newConnections = newConnectionList.stream().collect(Collectors.toMap(ConnectionPropertiesDTO::getId, i -> i));
        resultList.forEach(connection -> {
            ConnectionPropertiesDTO connectionToDelete = (ConnectionPropertiesDTO)newConnections.get(connection.getId());
            if (connectionToDelete == null) {
                allConnectionsToDelete.add(connection);
            }
        });
        if (allConnectionsToDelete != null && !allConnectionsToDelete.isEmpty()) {
            resultList.removeAll(allConnectionsToDelete);
        }
        this.connectionListView.getItems().clear();
        this.connectionListView.getItems().addAll((Collection)resultList.stream().sorted(Comparator.comparing(o -> (Integer)sorted.get(o.getId()))).collect(Collectors.toList()));
        boolean isEmpty = this.connectionListView.getItems().isEmpty();
        this.connectionListView.setVisible(!isEmpty);
        this.connectionListView.setManaged(!isEmpty);
        this.noConnectionsLabel.setVisible(isEmpty);
        this.noConnectionsLabel.setManaged(isEmpty);
        this.buttonBar.setVisible(!isEmpty);
        this.buttonBar.setManaged(!isEmpty);
        this.noConnectionsButtonBar.setVisible(isEmpty);
        this.noConnectionsButtonBar.setManaged(isEmpty);
        this.connectionListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateConnectButton());
        this.updateConnectButton();
        this.connectionListView.getSelectionModel().selectFirst();
        LOGGER.debug("Updated connections");
    }

    @FXML
    public void addConnection(ActionEvent actionEvent) {
        this.openSettings(true);
    }

    private void updateConnectButton() {
        ConnectionPropertiesDTO selectedConfig = (ConnectionPropertiesDTO)this.connectionListView.getSelectionModel().getSelectedItem();
        this.helloViewConnectButton.setDisable(selectedConfig == null);
    }

    @FXML
    public void onClickConnect(ActionEvent actionEvent) {
        LOGGER.debug("Clicked on connect button");
        this.connect();
    }

    private void connect() {
        ConnectionPropertiesDTO config = (ConnectionPropertiesDTO)this.connectionListView.getSelectionModel().getSelectedItem();
        this.connectionsOnboardingDelegate.onConnect(config);
    }

    public void openSettings(boolean autoNew) {
        ConnectionSettingsViewController.showAsDialog(this.connectionsSettingsViewDelegate);
        if (autoNew) {
            LOGGER.debug("Open settings with new default connection");
        } else {
            LOGGER.debug("Open settings for existing connections");
        }
    }

    @FXML
    public void openSettings() {
        this.openSettings(false);
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
    }

    @Override
    public void onConnectionsUpdated() {
        this.updateConnections();
    }

    @Override
    public void onConfigPrepareFailed() {
    }

    @Override
    public void onConnect(ConnectionPropertiesDTO config) {
    }
}

