/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.exception.CorreoMqttException;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.ControlBarDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.model.ConnectionState;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.spi.MainToolbarHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlBarController
extends BaseConnectionController
implements ConnectionLifecycleObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlBarController.class);
    private final ControlBarDelegate delegate;
    private final PluginManager pluginSystem = PluginManager.getInstance();
    @FXML
    public AnchorPane mainViewHBoxAnchorPane;
    @FXML
    public HBox controllViewButtonHBox;
    @FXML
    public HBox controllViewMainViewHBox;
    @FXML
    public Button connectBtn;
    @FXML
    public Button disconnectBtn;
    @FXML
    public ToggleButton controlViewPButton;
    @FXML
    public ToggleButton controlViewPSButton;
    @FXML
    public ToggleButton controlViewSButton;
    @FXML
    public Label statusLabel;
    @FXML
    public Label statusInfo;
    @FXML
    public Label brokerInfo;
    boolean gracefulDisconnenct = false;
    @FXML
    private ResourceBundle resources;

    public ControlBarController(String connectionId, ControlBarDelegate delegate) {
        super(connectionId);
        this.delegate = delegate;
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
    }

    static LoaderResult<ControlBarController> load(String connectionId, ControlBarDelegate delegate) {
        return ControlBarController.load(ControlBarController.class, "controlBarView.fxml", () -> new ControlBarController(connectionId, delegate));
    }

    @FXML
    public void initialize() {
        this.controlViewPSButton.setSelected(true);
        this.brokerInfo.setText("");
        this.disconnectBtn.setVisible(false);
        this.disconnectBtn.setManaged(false);
        int indexToInsert = this.controllViewButtonHBox.getChildrenUnmodifiable().indexOf((Object)this.controlViewSButton) + 1;
        this.pluginSystem.getExtensions(MainToolbarHook.class).forEach(p -> p.onInstantiateMainToolbar(this.getConnectionId(), this.controllViewButtonHBox, indexToInsert));
    }

    @FXML
    public void onClickConnect(ActionEvent actionEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Connect in control bar clicked for connection: {}", (Object)this.getConnectionId());
        }
        TaskFactory.connect(this.getConnectionId());
    }

    @FXML
    public void onClickDisconnect() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Disconnect in control bar clicked for connection: {}", (Object)this.getConnectionId());
        }
        this.gracefulDisconnenct = true;
        TaskFactory.disconnect(this.getConnectionId());
    }

    @FXML
    public void onClickP() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Show only publish clicked: {}", (Object)this.getConnectionId());
        }
        this.delegate.setLayout(true, false);
        this.controlViewPButton.setSelected(true);
        this.controlViewPSButton.setSelected(false);
        this.controlViewSButton.setSelected(false);
    }

    @FXML
    public void onClickPS() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Show publish AND subscribe clicked: {}", (Object)this.getConnectionId());
        }
        this.delegate.setLayout(true, true);
        this.controlViewPButton.setSelected(false);
        this.controlViewPSButton.setSelected(true);
        this.controlViewSButton.setSelected(false);
    }

    @FXML
    public void onClickS() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Show only subscribe clicked: {}", (Object)this.getConnectionId());
        }
        this.delegate.setLayout(false, true);
        this.controlViewPButton.setSelected(false);
        this.controlViewPSButton.setSelected(false);
        this.controlViewSButton.setSelected(true);
    }

    private void setGuiDisconnected() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set gui to disconnected state: {}", (Object)this.getConnectionId());
        }
        this.statusLabel.getStyleClass().clear();
        if (this.gracefulDisconnenct) {
            this.statusLabel.getStyleClass().add((Object)"grayStatus");
            this.delegate.setConnectionState(ConnectionState.DISCONNECTED_GRACEFUL);
            this.gracefulDisconnenct = false;
        } else {
            this.statusLabel.getStyleClass().add((Object)"redStatus");
            this.delegate.setConnectionState(ConnectionState.DISCONNECTED_UNGRACEFUL);
        }
        this.statusInfo.setVisible(true);
        this.statusInfo.setManaged(true);
        this.updateBrokerInfo();
        this.connectBtn.setVisible(true);
        this.connectBtn.setManaged(true);
        this.connectBtn.setDisable(false);
        this.disconnectBtn.setVisible(false);
        this.disconnectBtn.setManaged(false);
        this.controlViewPSButton.setDisable(true);
        this.controlViewPButton.setDisable(true);
        this.controlViewSButton.setDisable(true);
    }

    private void updateBrokerInfo() {
        ConnectionConfigDTO config = ConnectionHolder.getInstance().getConfig(this.getConnectionId());
        if (config != null) {
            this.brokerInfo.setText(config.getHostAndPort());
        }
    }

    private void setGuiConnected() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set gui to connected state: {}", (Object)this.getConnectionId());
        }
        this.statusInfo.setVisible(false);
        this.statusInfo.setManaged(false);
        this.updateBrokerInfo();
        this.connectBtn.setVisible(false);
        this.connectBtn.setManaged(false);
        this.disconnectBtn.setVisible(true);
        this.disconnectBtn.setManaged(true);
        this.disconnectBtn.setDisable(false);
        this.statusLabel.getStyleClass().clear();
        this.statusLabel.getStyleClass().add((Object)"greenStatus");
        this.delegate.setConnectionState(ConnectionState.CONNECTED);
        this.controlViewPSButton.setDisable(false);
        this.controlViewPButton.setDisable(false);
        this.controlViewSButton.setDisable(false);
    }

    private void setGuiConnecting() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set gui to connecting state: {}", (Object)this.getConnectionId());
        }
        this.statusInfo.setVisible(true);
        this.statusInfo.setManaged(true);
        this.updateBrokerInfo();
        this.connectBtn.setDisable(true);
        this.statusLabel.getStyleClass().clear();
        this.statusLabel.getStyleClass().add((Object)"yellowStatus");
        this.delegate.setConnectionState(ConnectionState.CONNECTING);
        this.controlViewPSButton.setDisable(true);
        this.controlViewPButton.setDisable(true);
        this.controlViewSButton.setDisable(true);
    }

    private void setGuiDisconnecting() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set gui to disconnecting state: {}", (Object)this.getConnectionId());
        }
        this.statusInfo.setVisible(true);
        this.statusInfo.setManaged(true);
        this.updateBrokerInfo();
        this.disconnectBtn.setDisable(true);
        this.statusLabel.getStyleClass().clear();
        this.statusLabel.getStyleClass().add((Object)"yellowStatus");
        this.delegate.setConnectionState(ConnectionState.DISCONNECTING);
        this.controlViewPSButton.setDisable(true);
        this.controlViewPButton.setDisable(true);
        this.controlViewSButton.setDisable(true);
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerConnected"));
            this.setGuiConnected();
        });
    }

    @Override
    public void onConnectRunning() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerConnecting"));
            this.setGuiConnecting();
        });
    }

    @Override
    public void onConnectionFailed(Throwable e) {
        Object msg = e instanceof CorreoMqttException ? ((CorreoMqttException)e).getInfo() : e.getClass().toString() + ":" + e.getMessage();
        Platform.runLater(() -> this.lambda$onConnectionFailed$4((String)msg));
    }

    @Override
    public void onConnectionCanceled() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerConnectCanceled"));
            this.setGuiConnecting();
        });
    }

    @Override
    public void onConnectionLost() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerConnectLost"));
            this.setGuiConnecting();
        });
    }

    @Override
    public void onDisconnect() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerDisconnected"));
            this.setGuiDisconnected();
        });
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerDisconnectFailed"));
            this.setGuiConnected();
        });
    }

    @Override
    public void onDisconnectRunning() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerDisconnecting"));
            this.setGuiDisconnecting();
        });
    }

    @Override
    public void onConnectionReconnected() {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerConnected"));
            this.setGuiConnected();
        });
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
        Platform.runLater(() -> {
            this.statusInfo.setText(this.resources.getString("controlBarControllerReconnecting") + " " + triedReconnects + "/" + maxReconnects);
            this.setGuiConnecting();
        });
    }

    private /* synthetic */ void lambda$onConnectionFailed$4(String msg) {
        this.statusInfo.setText(msg);
        this.setGuiDisconnected();
    }
}

