/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.provider.PersistPublishHistoryProvider;
import org.correomqtt.business.provider.PersistPublishMessageHistoryProvider;
import org.correomqtt.business.provider.PersistSubscriptionHistoryProvider;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.controller.AboutViewController;
import org.correomqtt.gui.controller.ConnectionOnboardingDelegate;
import org.correomqtt.gui.controller.ConnectionOnbordingViewController;
import org.correomqtt.gui.controller.ConnectionSettingsViewController;
import org.correomqtt.gui.controller.ConnectionSettingsViewDelegate;
import org.correomqtt.gui.controller.ConnectionViewController;
import org.correomqtt.gui.controller.ConnectionViewDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.LogTabController;
import org.correomqtt.gui.controller.PluginsViewController;
import org.correomqtt.gui.controller.SettingsViewController;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;
import org.correomqtt.gui.model.ConnectionState;
import org.correomqtt.gui.transformer.ConnectionTransformer;
import org.correomqtt.gui.utils.CheckNewVersionUtils;
import org.correomqtt.gui.utils.HostServicesHolder;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainViewController
implements ConnectionOnboardingDelegate,
ConnectionViewDelegate,
ConfigObserver,
ConnectionSettingsViewDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainViewController.class);
    @FXML
    public TabPane tabPane;
    @FXML
    public Tab logTab;
    @FXML
    public AnchorPane logAnchorPane;
    @FXML
    public Tab addTab;
    @FXML
    public AnchorPane tabPaneAnchorPane;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Menu fileMenu;
    @FXML
    private MenuItem closeItem;
    @FXML
    private Menu toolsMenu;
    @FXML
    private MenuItem connectionsItem;
    @FXML
    private MenuItem settingsItem;
    @FXML
    private Menu helpMenu;
    @FXML
    private MenuItem aboutItem;
    @FXML
    private MenuItem updateItem;
    @FXML
    private MenuItem websiteItem;
    @FXML
    private Menu pluginMenu;
    @FXML
    private MenuItem pluginSettingsItem;
    private SelectionModel<Tab> selectionModel;
    private ResourceBundle resources;

    public MainViewController() {
        ConfigDispatcher.getInstance().addObserver(this);
    }

    @FXML
    public void initialize() {
        this.tabPaneAnchorPane.getStyleClass().add((Object)SettingsProvider.getInstance().getIconModeCssClass());
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.setupAddTab();
        this.createLogTab();
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("Mac")) {
            this.menuBar.getMenus().remove((Object)this.fileMenu);
            this.menuBar.useSystemMenuBarProperty().set(true);
            AnchorPane.setTopAnchor((Node)this.tabPane, (Double)0.0);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.setMenuEventHandler();
        this.tabPane.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().isDigitKey() && event.isShortcutDown()) {
                this.selectionModel.select(Integer.parseInt(event.getText()) - 1);
            }
        });
        this.tabPane.widthProperty().addListener((a, b, c) -> this.calcTabWidth());
    }

    private void setupAddTab() {
        this.addTab.setClosable(false);
        LoaderResult<ConnectionOnbordingViewController> loadResult = ConnectionOnbordingViewController.load(this, this);
        this.addTab.setContent((Node)loadResult.getMainPane());
        this.resources = loadResult.getResourceBundle();
        this.selectionModel = this.tabPane.getSelectionModel();
        this.selectionModel.select((Object)this.addTab);
    }

    private void createLogTab() {
        LoaderResult<LogTabController> result = LogTabController.load();
        LogTabController logViewController = result.getController();
        this.logTab.setClosable(false);
        this.logAnchorPane.getChildren().add((Object)logViewController.logViewAnchor);
        logViewController.logViewAnchor.prefWidthProperty().bind((ObservableValue)this.logAnchorPane.widthProperty());
        logViewController.logViewAnchor.prefHeightProperty().bind((ObservableValue)this.logAnchorPane.heightProperty());
    }

    private void setMenuEventHandler() {
        this.closeItem.setOnAction(event -> System.exit(0));
        this.connectionsItem.setOnAction(event -> ConnectionSettingsViewController.showAsDialog(this));
        this.settingsItem.setOnAction(event -> SettingsViewController.showAsDialog());
        this.aboutItem.setOnAction(event -> AboutViewController.showAsDialog());
        this.updateItem.setOnAction(event -> {
            try {
                CheckNewVersionUtils.checkNewVersion(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        });
        this.websiteItem.setOnAction(event -> HostServicesHolder.getInstance().getHostServices().showDocument(new Hyperlink("http://correomqtt.org").getText()));
        this.pluginSettingsItem.setOnAction(event -> this.openPluginSettings());
    }

    private void openPluginSettings() {
        PluginsViewController.showAsDialog();
    }

    public String getUUIDofSelectedTab() {
        Tab selectedTab = (Tab)this.selectionModel.getSelectedItem();
        return selectedTab.getId();
    }

    @Override
    public void setTabName(String tabId, String name) {
        this.tabPane.getTabs().stream().filter(t -> t.getId().equals(tabId)).findFirst().ifPresent(t -> t.setText(name));
        this.calcTabWidth();
    }

    @Override
    public void onConnect(ConnectionPropertiesDTO config) {
        if (ConnectionHolder.getInstance().isConnectionUnused(ConnectionTransformer.propsToDto(config))) {
            String tabId = UUID.randomUUID().toString();
            PersistPublishHistoryProvider.activate(config.getId());
            PersistPublishMessageHistoryProvider.activate(config.getId());
            PersistSubscriptionHistoryProvider.activate(config.getId());
            Tab tab = new Tab();
            tab.setId(tabId);
            tab.setClosable(true);
            tab.setText(config.getName());
            tab.setOnSelectionChanged(event -> {
                if (tab.isSelected()) {
                    tab.getStyleClass().removeAll((Object[])new String[]{"dirty"});
                }
            });
            tab.getStyleClass().add((Object)"connection");
            config.getNameProperty().addListener((observableValue, s, t1) -> tab.setText(t1));
            LoaderResult<ConnectionViewController> result = ConnectionViewController.load(config.getId(), this);
            result.getController().setTabId(tabId);
            tab.setContent((Node)result.getMainPane());
            tab.setOnCloseRequest(event -> ((ConnectionViewController)result.getController()).disconnect());
            this.tabPane.getTabs().add(this.tabPane.getTabs().size() - 1, (Object)tab);
            this.selectionModel = this.tabPane.getSelectionModel();
            this.selectionModel.select((Object)tab);
            LOGGER.debug("New tab created");
            result.getController().connect(config);
            this.calcTabWidth();
        } else {
            AlertHelper.warn(this.resources.getString("mainViewControllerAlreadyUsedTitle"), this.resources.getString("mainViewControllerAlreadyUsedContent"));
        }
    }

    private void calcTabWidth() {
        ObservableList tabs = FXCollections.observableArrayList((Collection)this.tabPane.getTabs());
        this.tabPane.setTabMaxWidth((this.tabPane.widthProperty().doubleValue() - 80.0) / (double)Math.max(1, tabs.size() - 2) - 25.0);
    }

    @Override
    public void onDisconnect() {
        this.calcTabWidth();
    }

    @Override
    public void setTabDirty(String tabId) {
        this.tabPane.getTabs().stream().filter(t -> tabId.equals(t.getId())).findFirst().ifPresent(t -> {
            if (!t.isSelected()) {
                t.getStyleClass().removeAll((Object[])new String[]{"dirty"});
                t.getStyleClass().add((Object)"dirty");
            }
        });
    }

    @Override
    public void setConnectionState(String tabId, ConnectionState state) {
        this.tabPane.getTabs().stream().filter(t -> t.getId().equals(tabId)).findFirst().ifPresent(t -> {
            t.getStyleClass().removeAll((Object[])new String[]{"connected", "connecting", "disconnecting", "graceful", "ungraceful"});
            t.getStyleClass().add((Object)state.getCssClass());
        });
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
    }

    @Override
    public void onConnectionsUpdated() {
    }

    @Override
    public void onConfigPrepareFailed() {
    }

    @Override
    public void closeTab(String connectionName) {
        this.tabPane.getTabs().stream().filter(t -> connectionName.equals(t.getText())).findFirst().ifPresent(t -> this.tabPane.getTabs().remove(t));
        LOGGER.info("Closing tab for connection: " + connectionName);
    }
}

