/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.model.MessageType;
import org.correomqtt.business.model.PublishStatus;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.cell.MessageViewCell;
import org.correomqtt.gui.contextmenu.MessageListContextMenu;
import org.correomqtt.gui.contextmenu.MessageListContextMenuDelegate;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.DetailViewController;
import org.correomqtt.gui.controller.DetailViewDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.MessageListViewDelegate;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.correomqtt.gui.transformer.MessageTransformer;
import org.correomqtt.gui.utils.MessageUtils;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.model.MessageExtensionDTO;
import org.correomqtt.plugin.spi.MessageIncomingHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListViewController
extends BaseConnectionController
implements ConnectionLifecycleObserver,
MessageListContextMenuDelegate,
DetailViewDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListViewController.class);
    private final MessageListViewDelegate delegate;
    @FXML
    Button clearMessagesButton;
    @FXML
    Button copyToFormButton;
    @FXML
    ListView<MessagePropertiesDTO> listView;
    @FXML
    Button showDetailsButton;
    @FXML
    private SplitPane splitPane;
    @FXML
    private VBox messagesVBox;
    @FXML
    private TextField messageSearchTextField;
    @FXML
    private Button messageSearchClearButton;
    @FXML
    private ToggleButton showDetailViewButton;
    private ObservableList<MessagePropertiesDTO> messages;
    private FilteredList<MessagePropertiesDTO> filteredMessages;
    private DetailViewController detailViewController;

    public MessageListViewController(String connectionId, MessageListViewDelegate delegate) {
        super(connectionId);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        this.delegate = delegate;
    }

    public static LoaderResult<MessageListViewController> load(String connectionId, MessageListViewDelegate delegate) {
        return MessageListViewController.load(MessageListViewController.class, "messageListView.fxml", () -> new MessageListViewController(connectionId, delegate));
    }

    @FXML
    public void initialize() {
        this.splitPane.getStyleClass().add((Object)SettingsProvider.getInstance().getIconModeCssClass());
        this.copyToFormButton.setDisable(true);
        this.showDetailsButton.setDisable(true);
        this.clearMessagesButton.setDisable(true);
        this.messages = FXCollections.observableArrayList(MessagePropertiesDTO.extractor());
        this.filteredMessages = new FilteredList(this.messages, s -> true);
        this.listView.setItems(this.filteredMessages);
        this.listView.setCellFactory(this::createCell);
        this.splitPane.widthProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            if (newValue.intValue() <= 670) {
                this.closeDetailView();
                this.showDetailViewButton.setDisable(true);
            } else {
                this.showDetailViewButton.setDisable(false);
                if (this.showDetailViewButton.isSelected()) {
                    this.showDetailView();
                }
            }
        }));
        this.messageSearchTextField.textProperty().addListener((observable, oldValue, newValue) -> this.searchInMessages((String)newValue));
    }

    private void searchInMessages(String newValue) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Search for " + newValue + " in messages: {}", (Object)this.getConnectionId());
        }
        this.filteredMessages.setPredicate(message -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            return message.getTopic().contains(newValue);
        });
    }

    @FXML
    private void resetMessageSearchTextField() {
        this.messageSearchTextField.textProperty().setValue("");
    }

    private ListCell<MessagePropertiesDTO> createCell(ListView<MessagePropertiesDTO> listView) {
        MessageViewCell cell = new MessageViewCell(listView);
        MessageListContextMenu contextMenu = new MessageListContextMenu(this);
        cell.setContextMenu(contextMenu);
        cell.itemProperty().addListener((observable, oldValue, newValue) -> contextMenu.setObject((MessagePropertiesDTO)newValue));
        cell.setOnMouseClicked(event -> this.onCellClicked((MouseEvent)event, (MessagePropertiesDTO)cell.getItem()));
        cell.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.copyToFormButton.setDisable(false);
                this.showDetailsButton.setDisable(false);
                if (this.detailViewController != null) {
                    this.detailViewController.setMessage((MessagePropertiesDTO)cell.getItem());
                }
            }
        });
        return cell;
    }

    private void onCellClicked(MouseEvent event, MessagePropertiesDTO messageDTO) {
        if (messageDTO != null && event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
            DetailViewController.showAsDialog(messageDTO, this.getConnectionId(), this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Message selected in list: {}: {}", (Object)(messageDTO != null ? messageDTO.getTopic() : null), (Object)this.getConnectionId());
        }
    }

    @Override
    @FXML
    public void clearList() {
        if (this.detailViewController != null) {
            this.detailViewController.setMessage(null);
        }
        this.messages.clear();
        this.copyToFormButton.setDisable(true);
        this.showDetailsButton.setDisable(true);
        this.clearMessagesButton.setDisable(true);
        this.delegate.clearMessages();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Message list cleared: {}", (Object)this.getConnectionId());
        }
    }

    @Override
    public void removeMessage(MessagePropertiesDTO messageDTO) {
        this.messages.remove((Object)messageDTO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Message removed from list: {}: {}", (Object)messageDTO.getTopic(), (Object)this.getConnectionId());
        }
        this.delegate.removeMessage(MessageTransformer.propsToDTO(messageDTO));
    }

    @Override
    public void saveMessage(MessagePropertiesDTO messageDTO) {
        Stage stage = (Stage)this.messagesVBox.getScene().getWindow();
        MessageUtils.saveMessage(this.getConnectionId(), messageDTO, stage);
    }

    void setFilterPredicate(Predicate<MessagePropertiesDTO> filterPredicate) {
        this.filteredMessages.setPredicate(filterPredicate);
    }

    Node getMainNode() {
        return this.splitPane;
    }

    private MessagePropertiesDTO getSelectedMessage() {
        return (MessagePropertiesDTO)this.listView.getSelectionModel().getSelectedItem();
    }

    void onNewMessage(MessagePropertiesDTO messageDTO) {
        if (messageDTO.getSubscription() != null && messageDTO.getSubscription().isHidden()) {
            return;
        }
        if (messageDTO.getTopic().startsWith("$SYS")) {
            return;
        }
        this.delegate.setTabDirty();
        if (messageDTO.getPublishStatus() != null && messageDTO.getPublishStatus().equals((Object)PublishStatus.PUBLISEHD)) {
            this.messages.stream().filter(m -> m.getMessageId().equals(messageDTO.getMessageId())).findFirst().ifPresentOrElse(m -> m.setPublishStatus(PublishStatus.PUBLISEHD), () -> this.addMessage(messageDTO));
            return;
        }
        if (messageDTO.getPublishStatus() != null && messageDTO.getPublishStatus().equals((Object)PublishStatus.SUCCEEDED)) {
            this.messages.stream().filter(m -> m.getMessageId().equals(messageDTO.getMessageId())).findFirst().ifPresentOrElse(m -> m.setPublishStatus(PublishStatus.SUCCEEDED), () -> this.addMessage(messageDTO));
            return;
        }
        if (messageDTO.getPublishStatus() != null && messageDTO.getPublishStatus().equals((Object)PublishStatus.FAILED)) {
            this.messages.stream().filter(m -> m.getMessageId().equals(messageDTO.getMessageId())).findFirst().ifPresentOrElse(m -> m.setPublishStatus(PublishStatus.FAILED), () -> this.addMessage(messageDTO));
            return;
        }
        if (messageDTO.getMessageType().equals((Object)MessageType.INCOMING)) {
            this.addMessage(messageDTO);
        }
    }

    private void addMessage(MessagePropertiesDTO messageDTO) {
        MessagePropertiesDTO updatedMessageDTO = this.executeOnMessageIncomingExtensions(messageDTO);
        Platform.runLater(() -> {
            this.messages.add(0, (Object)updatedMessageDTO);
            this.clearMessagesButton.setDisable(false);
        });
    }

    private MessagePropertiesDTO executeOnMessageIncomingExtensions(MessagePropertiesDTO messageDTO) {
        MessageExtensionDTO messageExtensionDTO = new MessageExtensionDTO(messageDTO);
        for (MessageIncomingHook p : PluginManager.getInstance().getExtensions(MessageIncomingHook.class)) {
            messageExtensionDTO = p.onMessageIncoming(this.getConnectionId(), messageExtensionDTO);
        }
        return messageExtensionDTO.merge(messageDTO);
    }

    @FXML
    private void copyToForm() {
        this.delegate.setUpToForm(this.getSelectedMessage());
    }

    @FXML
    private void showDetailsOfMessage() {
        DetailViewController.showAsDialog(this.getSelectedMessage(), this.getConnectionId(), this);
    }

    @FXML
    private void toggleDetailView() {
        if (this.showDetailViewButton.isSelected()) {
            this.showDetailView();
        } else {
            this.closeDetailView();
        }
    }

    private void closeDetailView() {
        if (this.detailViewController != null) {
            this.splitPane.getItems().remove((Object)this.detailViewController.getMainNode());
            this.detailViewController = null;
        }
    }

    private void showDetailView() {
        if (this.detailViewController == null) {
            LoaderResult<DetailViewController> result = DetailViewController.load(this.getSelectedMessage(), this.getConnectionId(), this, true);
            this.detailViewController = result.getController();
            this.splitPane.getItems().add((Object)result.getMainPane());
        }
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
        this.setUpShortcuts();
    }

    private void setUpShortcuts() {
        this.listView.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ENTER == event.getCode()) {
                this.showDetailsOfMessage();
            }
        });
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionCanceled() {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
    }

    @Override
    public void onConnectScheduled() {
    }

    @Override
    public void onDisconnectCanceled() {
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onDisconnectScheduled() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    @Override
    public void showDetailsInSeparateWindow(MessagePropertiesDTO messageDTO) {
    }

    @Override
    public void setUpToForm(MessagePropertiesDTO messageDTO) {
        this.delegate.setUpToForm(messageDTO);
    }
}

