/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.File;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.ImportMessageDispatcher;
import org.correomqtt.business.dispatcher.ImportMessageObserver;
import org.correomqtt.business.dispatcher.PersistPublishHistoryDispatcher;
import org.correomqtt.business.dispatcher.PersistPublishHistoryObserver;
import org.correomqtt.business.dispatcher.PublishDispatcher;
import org.correomqtt.business.dispatcher.PublishGlobalDispatcher;
import org.correomqtt.business.dispatcher.PublishObserver;
import org.correomqtt.business.dispatcher.ShortcutDispatcher;
import org.correomqtt.business.dispatcher.ShortcutObserver;
import org.correomqtt.business.exception.CorreoMqttException;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.MessageType;
import org.correomqtt.business.model.PublishStatus;
import org.correomqtt.business.model.Qos;
import org.correomqtt.business.provider.PersistPublishHistoryProvider;
import org.correomqtt.business.provider.PersistPublishMessageHistoryProvider;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.cell.QosCell;
import org.correomqtt.gui.cell.TopicCell;
import org.correomqtt.gui.controller.BaseMessageBasedViewController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.LoadingViewController;
import org.correomqtt.gui.controller.PublishViewDelegate;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.helper.CheckTopicHelper;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.correomqtt.gui.transformer.MessageTransformer;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.model.MessageExtensionDTO;
import org.correomqtt.plugin.spi.MessageContextMenuHook;
import org.correomqtt.plugin.spi.PublishMenuHook;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishViewController
extends BaseMessageBasedViewController
implements ConnectionLifecycleObserver,
PublishObserver,
ConfigObserver,
ShortcutObserver,
ImportMessageObserver,
PersistPublishHistoryObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishViewController.class);
    private static ResourceBundle resources;
    private final PublishViewDelegate delegate;
    private final PluginManager pluginSystem = PluginManager.getInstance();
    @FXML
    public AnchorPane publishViewAnchor;
    @FXML
    public ComboBox<Qos> qosComboBox;
    @FXML
    public ComboBox<String> topicComboBox;
    @FXML
    public HBox pluginControlBox;
    @FXML
    public CheckBox retainedCheckBox;
    @FXML
    public Button publishButton;
    @FXML
    private CodeArea payloadCodeArea;
    @FXML
    private Pane codeAreaScrollPane;
    private LoadingViewController loadingViewController;

    public PublishViewController(String connectionId, PublishViewDelegate delegate) {
        super(connectionId);
        this.delegate = delegate;
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        PublishDispatcher.getInstance().addObserver(this);
        ConfigDispatcher.getInstance().addObserver(this);
        ShortcutDispatcher.getInstance().addObserver(this);
        ImportMessageDispatcher.getInstance().addObserver(this);
        PersistPublishHistoryDispatcher.getInstance().addObserver(this);
    }

    static LoaderResult<PublishViewController> load(String connectionId, PublishViewDelegate delegate) {
        LoaderResult<PublishViewController> result = PublishViewController.load(PublishViewController.class, "publishView.fxml", () -> new PublishViewController(connectionId, delegate));
        resources = result.getResourceBundle();
        return result;
    }

    @FXML
    public void initialize() {
        this.initMessageListView();
        this.qosComboBox.setItems(FXCollections.observableArrayList((Object[])Qos.values()));
        this.qosComboBox.getSelectionModel().selectFirst();
        this.qosComboBox.setCellFactory(QosCell::new);
        this.pluginSystem.getExtensions(PublishMenuHook.class).forEach(p -> {
            HBox pluginBox = new HBox();
            pluginBox.setAlignment(Pos.CENTER_RIGHT);
            this.pluginControlBox.getChildren().add((Object)pluginBox);
            p.onInstantiatePublishMenu(this.getConnectionId(), pluginBox);
        });
        this.topicComboBox.getEditor().lengthProperty().addListener((observable, oldValue, newValue) -> CheckTopicHelper.checkPublishTopic(this.topicComboBox, false));
        this.codeAreaScrollPane.getChildren().add((Object)new VirtualizedScrollPane((Node)this.payloadCodeArea));
        this.payloadCodeArea.prefWidthProperty().bind((ObservableValue)this.codeAreaScrollPane.widthProperty());
        this.payloadCodeArea.prefHeightProperty().bind((ObservableValue)this.codeAreaScrollPane.heightProperty());
        this.initTopicComboBox();
    }

    private void initTopicComboBox() {
        List<String> topics = PersistPublishHistoryProvider.getInstance(this.getConnectionId()).getTopics(this.getConnectionId());
        this.topicComboBox.setItems(FXCollections.observableArrayList(topics));
        this.topicComboBox.setCellFactory(TopicCell::new);
    }

    @FXML
    public void onClickPublishKey(KeyEvent actionEvent) {
        if (actionEvent.getCode() == KeyCode.ENTER) {
            this.topicComboBox.setValue((Object)this.topicComboBox.getEditor().getText());
            if (this.topicComboBox.getValue() == null) {
                return;
            }
            this.publish();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Publish button clicked.");
            }
        }
    }

    @FXML
    private void publish() {
        if (!CheckTopicHelper.checkPublishTopic(this.topicComboBox, true)) {
            return;
        }
        MessagePropertiesDTO messagePropertiesDTO = MessagePropertiesDTO.builder().topic((String)this.topicComboBox.getValue()).qos((Qos)((Object)this.qosComboBox.getSelectionModel().getSelectedItem())).isRetained(this.retainedCheckBox.isSelected()).payload(this.payloadCodeArea.getText()).messageId(UUID.randomUUID().toString()).messageType(MessageType.OUTGOING).dateTime(LocalDateTime.now()).build();
        TaskFactory.publish(this.getConnectionId(), messagePropertiesDTO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Publishing to topic: {}: {}", (Object)messagePropertiesDTO.getTopic(), (Object)this.getConnectionId());
        }
    }

    @FXML
    public void onClickScan() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Open file button clicked: {}", (Object)this.getConnectionId());
        }
        Stage stage = new Stage();
        stage.setAlwaysOnTop(true);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(resources.getString("publishViewControllerOpenFileTitle"));
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            TaskFactory.importMessage(this.getConnectionId(), file);
        }
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
        this.topicComboBox.valueProperty().set(null);
        this.payloadCodeArea.replaceText("");
        this.retainedCheckBox.setSelected(false);
        new LinkedList<MessageDTO>(PersistPublishMessageHistoryProvider.getInstance(this.getConnectionId()).getMessages(this.getConnectionId())).descendingIterator().forEachRemaining(messageDTO -> this.messageListViewController.onNewMessage(MessageTransformer.dtoToProps(messageDTO)));
    }

    @Override
    public void onConnectRunning() {
    }

    @Override
    public void onConnectionFailed(Throwable message) {
    }

    @Override
    public void onConnectionCanceled() {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onDisconnect() {
    }

    @Override
    public void onDisconnectCanceled() {
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onConnectionReconnected() {
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    @Override
    public void setUpToForm(MessagePropertiesDTO messageDTO) {
        this.executeOnCopyMessageToFormExtensions(messageDTO);
        if (messageDTO.isRetained()) {
            this.retainedCheckBox.setSelected(true);
        } else {
            this.retainedCheckBox.setSelected(false);
        }
        this.payloadCodeArea.replaceText(messageDTO.getPayload());
        this.topicComboBox.setValue((Object)messageDTO.getTopic());
        this.qosComboBox.setValue((Object)messageDTO.getQos());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Message copied to form: {}", (Object)this.getConnectionId());
        }
    }

    private void executeOnCopyMessageToFormExtensions(MessagePropertiesDTO messageDTO) {
        this.pluginSystem.getExtensions(MessageContextMenuHook.class).forEach(p -> p.onCopyMessageToPublishForm(this.getConnectionId(), new MessageExtensionDTO(messageDTO)));
    }

    @Override
    public void onConfigDirectoryEmpty() {
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
    }

    @Override
    public void onAppDataNull() {
    }

    @Override
    public void onUserHomeNull() {
    }

    @Override
    public void onFileAlreadyExists() {
    }

    @Override
    public void onInvalidPath() {
    }

    @Override
    public void onInvalidJsonFormat() {
    }

    @Override
    public void onSavingFailed() {
    }

    @Override
    public void onSettingsUpdated() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated settings in publish view controller: {}", (Object)this.getConnectionId());
        }
    }

    @Override
    public void onConnectionsUpdated() {
    }

    @Override
    public void onConfigPrepareFailed() {
    }

    @Override
    public void onPublishShortcutPressed() {
    }

    @Override
    public void onClearOutgoingShortcutPressed() {
    }

    @Override
    public void onPublishSucceeded(MessageDTO messageDTO) {
        messageDTO.setPublishStatus(PublishStatus.SUCCEEDED);
        this.messageListViewController.onNewMessage(MessageTransformer.dtoToProps(messageDTO));
    }

    @Override
    public void onPublishCancelled(MessageDTO messageDTO) {
        messageDTO.setPublishStatus(PublishStatus.FAILED);
        this.messageListViewController.onNewMessage(MessageTransformer.dtoToProps(messageDTO));
    }

    @Override
    public void onPublishFailed(MessageDTO messageDTO, Throwable exception) {
        messageDTO.setPublishStatus(PublishStatus.FAILED);
        this.messageListViewController.onNewMessage(MessageTransformer.dtoToProps(messageDTO));
        Object msg = exception instanceof CorreoMqttException ? ((CorreoMqttException)exception).getInfo() : "Exception in business layer: " + exception.getMessage();
        AlertHelper.warn(resources.getString("publishViewControllerPublishFailedTitle"), resources.getString("publishViewControllerPublishFailedContent") + ": " + messageDTO.getTopic() + ": " + (String)msg);
    }

    @Override
    public void onPublishRunning(MessageDTO messageDTO) {
    }

    @Override
    public void onPublishScheduled(MessageDTO messageDTO) {
        messageDTO.setPublishStatus(PublishStatus.PUBLISEHD);
        this.messageListViewController.onNewMessage(MessageTransformer.dtoToProps(messageDTO));
    }

    @Override
    public void onImportStarted(File file) {
        Platform.runLater(() -> {
            this.loadingViewController = LoadingViewController.showAsDialog(this.getConnectionId(), resources.getString("publishViewControllerOpenFileTitle") + ": " + file.getAbsolutePath());
            this.loadingViewController.setProgress(1);
        });
    }

    @Override
    public void onImportSucceeded(MessageDTO messageDTO) {
        Platform.runLater(() -> {
            this.topicComboBox.setValue((Object)messageDTO.getTopic());
            this.retainedCheckBox.setSelected(messageDTO.isRetained());
            this.qosComboBox.setValue((Object)messageDTO.getQos());
            this.payloadCodeArea.replaceText(messageDTO.getPayload());
            if (this.loadingViewController != null) {
                this.loadingViewController.close();
                this.loadingViewController = null;
            }
        });
    }

    @Override
    public void onImportCancelled(File file) {
        Platform.runLater(() -> {
            if (this.loadingViewController != null) {
                this.loadingViewController.close();
                this.loadingViewController = null;
            }
            AlertHelper.warn(resources.getString("publishViewControllerImportCancelledTitle"), resources.getString("publishViewControllerImportFileCancelledContent"));
        });
    }

    @Override
    public void onImportFailed(File file, Throwable exception) {
        Platform.runLater(() -> {
            if (this.loadingViewController != null) {
                this.loadingViewController.close();
                this.loadingViewController = null;
            }
            AlertHelper.warn(resources.getString("publishViewControllerImportFileFailedTitle"), resources.getString("publishViewControllerImportFileFailedContent"));
        });
    }

    @Override
    public void removeMessage(MessageDTO messageDTO) {
        PublishGlobalDispatcher.getInstance().onPublishRemoved(this.getConnectionId(), messageDTO);
    }

    @Override
    public void clearMessages() {
        PublishGlobalDispatcher.getInstance().onPublishesCleared(this.getConnectionId());
    }

    @Override
    public void setTabDirty() {
        this.delegate.setTabDirty();
    }

    @Override
    public void errorReadingPublishHistory(Throwable exception) {
    }

    @Override
    public void errorWritingPublishHistory(Throwable exception) {
    }

    @Override
    public void updatedPublishes(String connectionId) {
        this.initTopicComboBox();
    }
}

