/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import org.slf4j.LoggerFactory;

public class ToolTipDefaultsFixer {
    public static boolean setTooltipTimers(long openDelay, long visibleDuration, long closeDelay) {
        try {
            Class<?>[] classes;
            Field f = Tooltip.class.getDeclaredField("BEHAVIOR");
            f.setAccessible(true);
            for (Class<?> clazz : classes = Tooltip.class.getDeclaredClasses()) {
                if (!clazz.getName().equals("javafx.scene.control.Tooltip$TooltipBehavior")) continue;
                Constructor<?> ctor = clazz.getDeclaredConstructor(Duration.class, Duration.class, Duration.class, Boolean.TYPE);
                ctor.setAccessible(true);
                Object tooltipBehavior = ctor.newInstance(new Duration((double)openDelay), new Duration((double)visibleDuration), new Duration((double)closeDelay), false);
                f.set(null, tooltipBehavior);
                break;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ToolTipDefaultsFixer.class).error("Unexpected", (Throwable)e);
            return false;
        }
        return true;
    }
}

