/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin.manager;

import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.correomqtt.plugin.manager.PermissionPluginClassLoader;

public class PluginSecurityPolicy
extends Policy {
    private static final Permission[] FORBIDDEN_PERMISSIONS = new Permission[]{new RuntimePermission("createClassLoader"), new RuntimePermission("accessClassInPackage.sun"), new RuntimePermission("setSecurityManager"), new ReflectPermission("suppressAccessChecks"), new SecurityPermission("setPolicy"), new SecurityPermission("setProperty.package.access")};
    private HashMap<String, Permissions> pluginPermissions = new HashMap();

    void addPluginPermissions(String pluginName, Permissions permissions) {
        if (this.pluginPermissions.containsKey(pluginName)) {
            Permissions existingPermissions = this.pluginPermissions.get(pluginName);
            Iterator<Permission> permissionIterator = PluginSecurityPolicy.removeForbiddenPermissions(pluginName, permissions).elements().asIterator();
            while (permissionIterator.hasNext()) {
                Permission p = permissionIterator.next();
                existingPermissions.add(p);
            }
        } else {
            this.pluginPermissions.put(pluginName, PluginSecurityPolicy.removeForbiddenPermissions(pluginName, permissions));
        }
    }

    public static Permissions removeForbiddenPermissions(String pluginName, Permissions permissions) {
        Permissions cleanPermissions = new Permissions();
        Iterator<Permission> permissionIterator = permissions.elements().asIterator();
        while (permissionIterator.hasNext()) {
            Permission p = permissionIterator.next();
            if (!PluginSecurityPolicy.isPermissionAllowed(p)) continue;
            cleanPermissions.add(p);
        }
        return cleanPermissions;
    }

    private static boolean isPermissionAllowed(Permission permission) {
        if (permission instanceof FilePermission && permission.getActions().contains("execute")) {
            return false;
        }
        return Arrays.stream(FORBIDDEN_PERMISSIONS).noneMatch(p -> p.getClass().equals(permission.getClass()) && p.getName().equals(permission.getName()));
    }

    void addPluginPermission(String pluginName, Permission permission) {
        Permissions permissions = new Permissions();
        permissions.add(permission);
        this.addPluginPermissions(pluginName, permissions);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (this.isPlugin(domain)) {
            return this.pluginPermissions(((PermissionPluginClassLoader)((Object)domain.getClassLoader())).getPluginId());
        }
        return this.applicationPermissions();
    }

    private boolean isPlugin(ProtectionDomain domain) {
        return domain.getClassLoader() instanceof PermissionPluginClassLoader;
    }

    private PermissionCollection pluginPermissions(String name) {
        return this.pluginPermissions.getOrDefault(name, new Permissions());
    }

    private PermissionCollection applicationPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }
}

