/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin.manager;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.correomqtt.business.provider.ConfigProvider;
import org.correomqtt.plugin.manager.PermissionJarPluginLoader;
import org.correomqtt.plugin.manager.PermissionPluginFactory;
import org.correomqtt.plugin.manager.PluginExtensionFactory;
import org.correomqtt.plugin.manager.PluginProtocolParser;
import org.correomqtt.plugin.manager.ProtocolExtension;
import org.correomqtt.plugin.manager.ProtocolTask;
import org.correomqtt.plugin.manager.Task;
import org.correomqtt.plugin.spi.BaseExtensionPoint;
import org.correomqtt.plugin.spi.ExtensionId;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginFactory;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSystem
extends DefaultPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginSystem.class);
    private static PluginSystem instance;
    private PluginProtocolParser pluginProtocolParser;
    private final HashMap<String, List> extensionsCache = new HashMap();
    private final HashMap<String, List<Task>> taskCache = new HashMap();

    private PluginSystem() {
        super(Path.of(ConfigProvider.getInstance().getPluginJarPath(), new String[0]));
        try {
            this.pluginProtocolParser = new PluginProtocolParser();
        }
        catch (IOException | JDOMException e) {
            LOGGER.error("Cant't parse the protocol, please check the protocol.xml file.");
        }
    }

    protected PluginFactory createPluginFactory() {
        return new PermissionPluginFactory();
    }

    protected PluginLoader createPluginLoader() {
        return new PermissionJarPluginLoader((PluginManager)this);
    }

    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        return new ManifestPluginDescriptorFinder();
    }

    protected ExtensionFactory createExtensionFactory() {
        return new PluginExtensionFactory();
    }

    public static PluginSystem getInstance() {
        if (instance == null) {
            instance = new PluginSystem();
        }
        return instance;
    }

    public static PluginSystem createNewInstance() {
        instance = new PluginSystem();
        return instance;
    }

    public <T> List<T> getExtensions(Class<T> type) {
        if (!this.extensionsCache.containsKey(type.getSimpleName())) {
            this.extensionsCache.put(type.getSimpleName(), this.loadUserDefinedExtensions(type));
        }
        return this.extensionsCache.get(type.getSimpleName());
    }

    public <T> List<T> getExtensions(Class<T> type, Element root) {
        if (this.pluginProtocolParser == null) {
            return super.getExtensions(type);
        }
        List<ProtocolExtension> declaredExtensionsForClass = this.pluginProtocolParser.getProtocolExtensions(root);
        if (declaredExtensionsForClass.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createExtensions(type, declaredExtensionsForClass);
    }

    private <T> List<T> loadUserDefinedExtensions(Class<T> type) {
        if (this.pluginProtocolParser == null) {
            return super.getExtensions(type);
        }
        List<ProtocolExtension> declaredExtensionsForClass = this.pluginProtocolParser.getProtocolExtensions(type);
        if (declaredExtensionsForClass.isEmpty()) {
            return super.getExtensions(type);
        }
        return this.createExtensions(type, declaredExtensionsForClass);
    }

    public <T> List<Task<T>> getTasks(Class<T> type) {
        if (!this.taskCache.containsKey(type.getSimpleName())) {
            if (this.pluginProtocolParser == null) {
                this.taskCache.put(type.getSimpleName(), Collections.emptyList());
            } else {
                List<ProtocolTask> declaredTasks = this.pluginProtocolParser.getDeclaredTasks(type);
                if (declaredTasks.isEmpty()) {
                    this.taskCache.put(type.getSimpleName(), Collections.emptyList());
                } else {
                    this.taskCache.put(type.getSimpleName(), declaredTasks.stream().map(t -> this.createTask(type, (ProtocolTask)t)).filter(Objects::nonNull).collect(Collectors.toList()));
                }
            }
        }
        return this.taskCache.get(type.getSimpleName()).stream().map(t -> t).collect(Collectors.toList());
    }

    private <T> Task<T> createTask(Class<T> type, ProtocolTask protocolTask) {
        List<T> extensions = this.createExtensions(type, protocolTask.getTasks());
        if (extensions.size() == protocolTask.getTasks().size()) {
            return new Task<T>(protocolTask.getId(), extensions);
        }
        LOGGER.warn("Can't find all declared extensions for task {} in {}", (Object)protocolTask.getId(), (Object)type.getSimpleName());
        return null;
    }

    private <T> List<T> createExtensions(Class<T> type, List<ProtocolExtension> declaredExtensionsForClass) {
        return declaredExtensionsForClass.stream().map(pe -> this.createExtensionWithConfig(type, (ProtocolExtension)pe)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> T createExtensionWithConfig(Class<T> type, ProtocolExtension pe) {
        T baseExtensionPoint = this.getExtensionById(type, pe.getPluginName(), pe.getExtensionId());
        if (baseExtensionPoint != null) {
            ((BaseExtensionPoint)baseExtensionPoint).onConfigReceived(pe.getPluginConfig());
        }
        return baseExtensionPoint;
    }

    private <T> T getExtensionById(Class<T> type, String pluginId, String extensionId) {
        return (T)super.getExtensions(type, pluginId).stream().filter(e -> this.isExtensionIdResolved(e, extensionId)).findFirst().orElseGet(() -> {
            this.logInvalidPluginDeclaration(type, pluginId, extensionId);
            return null;
        });
    }

    private <T> boolean isExtensionIdResolved(T e, String id) {
        if (e.getClass().isAnnotationPresent(ExtensionId.class)) {
            return e.getClass().getAnnotation(ExtensionId.class).value().equals(id);
        }
        return true;
    }

    private <T> void logInvalidPluginDeclaration(Class<T> type, String pluginId, String extensionId) {
        Optional defaultExtension = super.getExtensions(type, pluginId).stream().findFirst();
        if (defaultExtension.isPresent()) {
            if (extensionId == null) {
                LOGGER.info("Plugin {} declared for {} offers multiple valid extensions, please specify an extensionId", (Object)pluginId, (Object)type.getSimpleName());
            } else {
                LOGGER.info("Plugin {} declared for {} has no extension named: {}", new Object[]{pluginId, type.getSimpleName(), extensionId});
            }
        } else if (this.getPlugin(pluginId).getPluginState().equals((Object)PluginState.STARTED)) {
            LOGGER.warn("Plugin {} declared for {} has no valid extension", (Object)pluginId, (Object)type.getSimpleName());
        } else {
            LOGGER.warn("Plugin {} declared for {} is not started", (Object)pluginId, (Object)type.getSimpleName());
        }
    }
}

