/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.encryption;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.correomqtt.business.encryption.Encryptor;
import org.correomqtt.business.model.PasswordsDTO;
import org.correomqtt.business.provider.EncryptionRecoverableException;

public class EncryptorAesGcm
implements Encryptor {
    public static final String ENCRYPTION_TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final int SALT_LENGTH_BYTE = 16;
    private final String password;

    public EncryptorAesGcm(String password) {
        this.password = password;
    }

    private static byte[] getRandomNonce(int length) {
        byte[] nonce = new byte[length];
        new SecureRandom().nextBytes(nonce);
        return nonce;
    }

    @Override
    public String decrypt(String encryptedData) throws EncryptionRecoverableException {
        try {
            byte[] decode = Base64.getDecoder().decode(encryptedData.getBytes(StandardCharsets.UTF_8));
            ByteBuffer bb = ByteBuffer.wrap(decode);
            byte[] iv = new byte[12];
            bb.get(iv);
            byte[] salt = new byte[16];
            bb.get(salt);
            byte[] cipherText = new byte[bb.remaining()];
            bb.get(cipherText);
            SecretKey aesKeyFromPassword = this.getAESKeyFromPassword(salt);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_TRANSFORMATION);
            cipher.init(2, (Key)aesKeyFromPassword, new GCMParameterSpec(128, iv));
            byte[] plainText = cipher.doFinal(cipherText);
            return new String(plainText, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionRecoverableException(e);
        }
    }

    @Override
    public String encrypt(String dataToEncrypt) throws EncryptionRecoverableException {
        try {
            byte[] salt = EncryptorAesGcm.getRandomNonce(16);
            byte[] iv = EncryptorAesGcm.getRandomNonce(12);
            SecretKey aesKeyFromPassword = this.getAESKeyFromPassword(salt);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_TRANSFORMATION);
            cipher.init(1, (Key)aesKeyFromPassword, new GCMParameterSpec(128, iv));
            byte[] cipherText = cipher.doFinal(dataToEncrypt.getBytes(StandardCharsets.UTF_8));
            byte[] cipherTextWithIvSalt = ByteBuffer.allocate(iv.length + salt.length + cipherText.length).put(iv).put(salt).put(cipherText).array();
            return Base64.getEncoder().encodeToString(cipherTextWithIvSalt);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionRecoverableException(e);
        }
    }

    @Override
    public String passwordsDTOtoString(PasswordsDTO passwordsDTO) {
        return passwordsDTO.getPasswords();
    }

    private SecretKey getAESKeyFromPassword(byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(this.password.toCharArray(), salt, 65536, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    @Override
    public String getEncryptionTranslation() {
        return ENCRYPTION_TRANSFORMATION;
    }
}

