/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.keyring;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.correomqtt.business.keyring.Keyring;
import org.correomqtt.business.keyring.KeyringException;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.spi.KeyringHook;

public class KeyringFactory {
    private KeyringFactory() {
    }

    public static Keyring create() {
        return (Keyring)KeyringFactory.getSupportedKeyrings().stream().findFirst().orElseThrow(() -> new KeyringException("No supported keyring backend found."));
    }

    public static Keyring createKeyringByIdentifier(String identifier) {
        return KeyringFactory.getSupportedKeyrings().stream().filter(k -> k.getIdentifier().equals(identifier)).findFirst().orElse(null);
    }

    private static List<Keyring> getAllKeyrings() {
        return PluginManager.getInstance().getExtensions(KeyringHook.class).stream().sorted(Comparator.comparingInt(Keyring::getSortIndex)).collect(Collectors.toList());
    }

    public static List<Keyring> getSupportedKeyrings() {
        return KeyringFactory.getAllKeyrings().stream().filter(Keyring::isSupported).collect(Collectors.toList());
    }
}

