/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.correomqtt.gui.model.GenericCellModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Auth implements GenericCellModel
{
    OFF("authEnumOff"),
    PASSWORD("authEnumPassword"),
    KEYFILE("authEnumKeyfile");

    private static final Logger LOGGER;
    private final String labelTranslationKey;

    private Auth(String labelTranslationKey) {
        this.labelTranslationKey = labelTranslationKey;
    }

    public String toString() {
        return this.labelTranslationKey;
    }

    @JsonCreator
    public static Auth fromJsonValue(String value) {
        try {
            return Auth.valueOf(value);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Unknown auth value {}", (Object)value);
            return OFF;
        }
    }

    @JsonValue
    public String toJsonValue() {
        return this.name();
    }

    @Override
    public String getLabelTranslationKey() {
        return this.labelTranslationKey;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Auth.class);
    }
}

