/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlobalUISettings {
    private double windowPositionX;
    private double windowPositionY;
    private double windowWidth;
    private double windowHeight;

    public double getWindowPositionX() {
        return this.windowPositionX;
    }

    public void setWindowPositionX(double windowPositionX) {
        this.windowPositionX = windowPositionX;
    }

    public double getWindowPositionY() {
        return this.windowPositionY;
    }

    public void setWindowPositionY(double windowPositionY) {
        this.windowPositionY = windowPositionY;
    }

    public double getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(double windowWidth) {
        this.windowWidth = windowWidth;
    }

    public double getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(double windowHeight) {
        this.windowHeight = windowHeight;
    }

    public static GlobalUISettingsBuilder builder() {
        return new GlobalUISettingsBuilder();
    }

    public GlobalUISettings(double windowPositionX, double windowPositionY, double windowWidth, double windowHeight) {
        this.windowPositionX = windowPositionX;
        this.windowPositionY = windowPositionY;
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
    }

    public GlobalUISettings() {
    }

    public static class GlobalUISettingsBuilder {
        private double windowPositionX;
        private double windowPositionY;
        private double windowWidth;
        private double windowHeight;

        GlobalUISettingsBuilder() {
        }

        public GlobalUISettingsBuilder windowPositionX(double windowPositionX) {
            this.windowPositionX = windowPositionX;
            return this;
        }

        public GlobalUISettingsBuilder windowPositionY(double windowPositionY) {
            this.windowPositionY = windowPositionY;
            return this;
        }

        public GlobalUISettingsBuilder windowWidth(double windowWidth) {
            this.windowWidth = windowWidth;
            return this;
        }

        public GlobalUISettingsBuilder windowHeight(double windowHeight) {
            this.windowHeight = windowHeight;
            return this;
        }

        public GlobalUISettings build() {
            return new GlobalUISettings(this.windowPositionX, this.windowPositionY, this.windowWidth, this.windowHeight);
        }

        public String toString() {
            return "GlobalUISettings.GlobalUISettingsBuilder(windowPositionX=" + this.windowPositionX + ", windowPositionY=" + this.windowPositionY + ", windowWidth=" + this.windowWidth + ", windowHeight=" + this.windowHeight + ")";
        }
    }
}

