/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.correomqtt.gui.model.GenericCellModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Lwt implements GenericCellModel
{
    OFF("lwtEnumOff"),
    ON("lwtEnumActive");

    private static final Logger LOGGER;
    private final String labelTranslationKey;

    private Lwt(String labelTranslationKey) {
        this.labelTranslationKey = labelTranslationKey;
    }

    public String toString() {
        return this.labelTranslationKey;
    }

    @JsonCreator
    public static Lwt fromJsonValue(String value) {
        try {
            return Lwt.valueOf(value);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Exception reading from json value.", (Throwable)iae);
            return OFF;
        }
    }

    @JsonValue
    public String toJsonValue() {
        return this.name();
    }

    @Override
    public String getLabelTranslationKey() {
        return this.labelTranslationKey;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Lwt.class);
    }
}

