/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.correomqtt.gui.model.GenericCellModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Proxy implements GenericCellModel
{
    OFF("proxyEnumOff"),
    SSH("proxyEnumSsh");

    private static final Logger LOGGER;
    private final String labelTranslationKey;

    private Proxy(String labelTranslationKey) {
        this.labelTranslationKey = labelTranslationKey;
    }

    public String toString() {
        return this.labelTranslationKey;
    }

    @JsonCreator
    public static Proxy fromJsonValue(String value) {
        try {
            return Proxy.valueOf(value);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Exception parsing json value.", (Throwable)iae);
            return OFF;
        }
    }

    @JsonValue
    public String toJsonValue() {
        return this.name();
    }

    @Override
    public String getLabelTranslationKey() {
        return this.labelTranslationKey;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Proxy.class);
    }
}

