/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.SecretStoreDispatcher;
import org.correomqtt.business.encryption.Encryptor;
import org.correomqtt.business.encryption.EncryptorAesCbc;
import org.correomqtt.business.encryption.EncryptorAesGcm;
import org.correomqtt.business.keyring.KeyringException;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.ConnectionPasswordType;
import org.correomqtt.business.model.PasswordsDTO;
import org.correomqtt.business.provider.BaseUserFileProvider;
import org.correomqtt.business.provider.EncryptionRecoverableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretStoreProvider
extends BaseUserFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretStoreProvider.class);
    private static final String PASSWORD_FILE_NAME = "passwords.json";
    private static final String EX_MSG_PREPARE_CONFIG = "Exception preparing password file.";
    private PasswordsDTO passwordsDTO;
    private Map<String, String> decryptedPasswords;
    private static SecretStoreProvider instance = null;

    public SecretStoreProvider() {
        try {
            this.prepareFile(PASSWORD_FILE_NAME);
        }
        catch (InvalidPathException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onInvalidPath();
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onFileAlreadyExists();
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        catch (SecurityException | AccessDeniedException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryNotAccessible();
        }
        catch (IOException | UnsupportedOperationException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigPrepareFailure();
        }
        try {
            this.passwordsDTO = (PasswordsDTO)new ObjectMapper().readValue(this.getFile(), PasswordsDTO.class);
        }
        catch (IOException e) {
            LOGGER.error("Password file can not be read. ", (Throwable)e);
            SecretStoreDispatcher.getInstance().onPasswordFileUnreadable();
            this.passwordsDTO = new PasswordsDTO();
        }
    }

    public static synchronized SecretStoreProvider getInstance() {
        if (instance == null) {
            instance = new SecretStoreProvider();
            return instance;
        }
        return instance;
    }

    public void setPassword(String masterPassword, ConnectionConfigDTO connection, ConnectionPasswordType type, String password) throws EncryptionRecoverableException {
        this.readDecryptedPasswords(this.getEncryptor(masterPassword)).put(this.getPasswordKey(connection, type), password);
    }

    public String getPassword(String masterPassword, ConnectionConfigDTO connection, ConnectionPasswordType type) throws EncryptionRecoverableException {
        return this.readDecryptedPasswords(this.getEncryptor(masterPassword)).get(this.getPasswordKey(connection, type));
    }

    private String getPasswordKey(ConnectionConfigDTO connection, ConnectionPasswordType type) {
        return connection.getId() + "_" + type.getLabel();
    }

    public void encryptAndSavePasswords(String masterPassword) throws EncryptionRecoverableException {
        Encryptor encryptor = this.getEncryptor(masterPassword);
        Map<String, String> localDecryptedPasswords = this.readDecryptedPasswords(encryptor);
        try {
            String encryptedPasswords = "";
            if (localDecryptedPasswords.size() != 0) {
                encryptedPasswords = encryptor.encrypt(new ObjectMapper().writeValueAsString(localDecryptedPasswords));
            }
            this.passwordsDTO.setSalt(null);
            this.passwordsDTO.setPasswords(encryptedPasswords);
            this.passwordsDTO.setEncryptionType(encryptor.getEncryptionTranslation());
            new ObjectMapper().writeValue(this.getFile(), (Object)this.passwordsDTO);
        }
        catch (IOException e) {
            LOGGER.error("Could not save encrypted passwords. ", (Throwable)e);
            throw new EncryptionRecoverableException();
        }
    }

    private Encryptor getEncryptor(String masterPassword) throws EncryptionRecoverableException {
        if (masterPassword == null || masterPassword.isEmpty()) {
            LOGGER.error("Password must not be empty.");
            throw new EncryptionRecoverableException();
        }
        return new EncryptorAesGcm(masterPassword);
    }

    private Map<String, String> readDecryptedPasswords(Encryptor encryptor) throws EncryptionRecoverableException {
        if (this.decryptedPasswords == null) {
            this.decryptedPasswords = this.passwordsDTO.getPasswords() == null ? new HashMap<String, String>() : this.decryptPasswords(encryptor);
        }
        return this.decryptedPasswords;
    }

    private Map<String, String> decryptPasswords(Encryptor encryptor) throws EncryptionRecoverableException {
        String encryptedPasswords = encryptor.passwordsDTOtoString(this.passwordsDTO);
        try {
            if (encryptedPasswords == null || encryptedPasswords.isEmpty()) {
                return new HashMap<String, String>();
            }
            return (Map)new ObjectMapper().readValue(encryptor.decrypt(encryptedPasswords), (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not read password file. ", (Throwable)e);
            throw new EncryptionRecoverableException();
        }
    }

    public void wipe() {
        this.decryptedPasswords = null;
        this.passwordsDTO.setSalt(null);
        this.passwordsDTO.setPasswords(null);
        this.passwordsDTO.setEncryptionType(null);
        Path path = this.getFile().toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(this.getFile().toPath());
            }
            catch (IOException e) {
                throw new KeyringException("Could not delete passwords.json file.", e);
            }
        }
    }

    public void ensurePasswordsAreDecrypted(String masterPassword) throws EncryptionRecoverableException {
        this.readDecryptedPasswords(this.getEncryptor(masterPassword));
    }

    public void migratePasswordEncryption(String masterPassword) throws EncryptionRecoverableException {
        if (this.passwordsDTO != null && this.passwordsDTO.getPasswords() != null && (this.passwordsDTO.getEncryptionType() == null || "AES/CBC/PKCS5Padding".equals(this.passwordsDTO.getEncryptionType()))) {
            LOGGER.info("Migrating password encryption from {} to {}", (Object)"AES/CBC/PKCS5Padding", (Object)"AES/GCM/NoPadding");
            this.readDecryptedPasswords(new EncryptorAesCbc(masterPassword));
            this.encryptAndSavePasswords(masterPassword);
        } else if (this.passwordsDTO != null && this.passwordsDTO.getPasswords() != null && (this.passwordsDTO.getEncryptionType() == null || "AES/GCM/NoPadding".equals(this.passwordsDTO.getEncryptionType()))) {
            LOGGER.info("Current password encryption is {}.", (Object)"AES/GCM/NoPadding");
        } else if (this.passwordsDTO == null || this.passwordsDTO.getPasswords() == null) {
            LOGGER.info("No passwords are stored currently.");
        } else {
            LOGGER.warn("Unknown password encryption: {}", (Object)this.passwordsDTO.getEncryptionType());
            throw new EncryptionRecoverableException("Unknown password encryption.");
        }
    }
}

