/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.provider;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.model.ConfigDTO;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.ConnectionPasswordType;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.model.ThemeSettingsDTO;
import org.correomqtt.business.provider.BaseUserFileProvider;
import org.correomqtt.business.provider.EncryptionRecoverableException;
import org.correomqtt.business.provider.SecretStoreProvider;
import org.correomqtt.business.utils.ConnectionHolder;
import org.correomqtt.gui.keyring.KeyringHandler;
import org.correomqtt.gui.theme.ThemeProvider;
import org.correomqtt.gui.theme.light.LightThemeProvider;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.spi.ThemeProviderHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsProvider
extends BaseUserFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsProvider.class);
    private static final String CONFIG_FILE_NAME = "config.json";
    private static final String CSS_FILE_NAME = "style.css";
    private static final String EX_MSG_PREPARE_CONFIG = "Exception preparing config file.";
    private static final String EX_MSG_WRITE_CONFIG = "Exception writing config file.";
    private ThemeProvider activeThemeProvider;
    private static SettingsProvider instance = null;
    private ConfigDTO configDTO;

    private SettingsProvider() {
        try {
            this.prepareFile(CONFIG_FILE_NAME);
        }
        catch (InvalidPathException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onInvalidPath();
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onFileAlreadyExists();
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        catch (SecurityException | AccessDeniedException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryNotAccessible();
        }
        catch (IOException | UnsupportedOperationException e) {
            LOGGER.error(EX_MSG_PREPARE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigPrepareFailure();
        }
        try {
            this.configDTO = (ConfigDTO)new ObjectMapper().readValue(this.getFile(), ConfigDTO.class);
        }
        catch (IOException e) {
            LOGGER.error("Exception parsing config file.", (Throwable)e);
            ConfigDispatcher.getInstance().onInvalidJsonFormat();
        }
    }

    public static synchronized SettingsProvider getInstance() {
        if (instance == null) {
            instance = new SettingsProvider();
            return instance;
        }
        return instance;
    }

    private ThemeProvider getActiveTheme() {
        if (this.activeThemeProvider == null) {
            String activeThemeName = this.configDTO.getThemesSettings().getActiveTheme().getName();
            ArrayList<ThemeProviderHook> themes = new ArrayList<ThemeProviderHook>(PluginManager.getInstance().getExtensions(ThemeProviderHook.class));
            this.activeThemeProvider = themes.stream().filter(t -> t.getName().equals(activeThemeName)).findFirst().orElse(new LightThemeProvider());
        }
        return this.activeThemeProvider;
    }

    public List<ConnectionConfigDTO> getConnectionConfigs() {
        return this.configDTO.getConnections();
    }

    public SettingsDTO getSettings() {
        return this.configDTO.getSettings();
    }

    public ThemeSettingsDTO getThemeSettings() {
        return this.configDTO.getThemesSettings();
    }

    public void saveSettings(boolean showRestartRequiredDialog) {
        this.activeThemeProvider = null;
        this.saveDTO();
        this.saveToUserDirectory(CSS_FILE_NAME, this.getActiveTheme().getCss());
        ConfigDispatcher.getInstance().onSettingsUpdated(showRestartRequiredDialog);
    }

    public void saveConnections(List<ConnectionConfigDTO> connections, String masterPassword) throws EncryptionRecoverableException {
        this.configDTO.setConnections(connections);
        this.saveDTO();
        SecretStoreProvider secretStoreProvider = SecretStoreProvider.getInstance();
        for (ConnectionConfigDTO c : connections) {
            secretStoreProvider.setPassword(masterPassword, c, ConnectionPasswordType.PASSWORD, c.getPassword());
            secretStoreProvider.setPassword(masterPassword, c, ConnectionPasswordType.AUTH_PASSWORD, c.getAuthPassword());
            secretStoreProvider.setPassword(masterPassword, c, ConnectionPasswordType.SSL_KEYSTORE_PASSWORD, c.getSslKeystorePassword());
        }
        secretStoreProvider.encryptAndSavePasswords(masterPassword);
        ConnectionHolder.getInstance().refresh();
        ConfigDispatcher.getInstance().onConnectionsUpdated();
    }

    private void saveDTO() {
        try {
            new ObjectMapper().writeValue(this.getFile(), (Object)this.configDTO);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(EX_MSG_WRITE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onConfigDirectoryEmpty();
        }
        catch (JsonGenerationException | JsonMappingException e) {
            LOGGER.error(EX_MSG_WRITE_CONFIG, e);
            ConfigDispatcher.getInstance().onInvalidJsonFormat();
        }
        catch (IOException e) {
            LOGGER.error(EX_MSG_WRITE_CONFIG, (Throwable)e);
            ConfigDispatcher.getInstance().onSavingFailed();
        }
    }

    public void wipeSecretData(String masterPassword) throws EncryptionRecoverableException {
        KeyringHandler.getInstance().wipe();
        List<ConnectionConfigDTO> connections = this.getConnectionConfigs();
        connections.forEach(c -> {
            c.setPassword(null);
            c.setAuthPassword(null);
            c.setSslKeystorePassword(null);
        });
        this.saveConnections(connections, masterPassword);
    }

    public String getCssPath() {
        File cssFile = new File(this.getTargetDirectoryPath() + File.separator + CSS_FILE_NAME);
        if (!cssFile.exists()) {
            this.saveToUserDirectory(CSS_FILE_NAME, this.getActiveTheme().getCss());
        }
        if (cssFile.exists()) {
            return cssFile.toURI().toString();
        }
        return null;
    }

    public String getLogPath() {
        return this.getTargetDirectoryPath() + File.separator;
    }

    public String getIconModeCssClass() {
        return this.configDTO.getThemesSettings().getActiveTheme().getIconMode().toString();
    }

    public void initializePasswords(String masterPassword) throws EncryptionRecoverableException {
        SecretStoreProvider secretStoreProvider = SecretStoreProvider.getInstance();
        secretStoreProvider.migratePasswordEncryption(masterPassword);
        List<ConnectionConfigDTO> connections = this.getConnectionConfigs();
        for (ConnectionConfigDTO c : connections) {
            c.setPassword(secretStoreProvider.getPassword(masterPassword, c, ConnectionPasswordType.PASSWORD));
            c.setAuthPassword(secretStoreProvider.getPassword(masterPassword, c, ConnectionPasswordType.AUTH_PASSWORD));
            c.setSslKeystorePassword(secretStoreProvider.getPassword(masterPassword, c, ConnectionPasswordType.SSL_KEYSTORE_PASSWORD));
        }
        this.saveConnections(connections, masterPassword);
    }
}

