/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.correomqtt.business.dispatcher.PublishDispatcher;
import org.correomqtt.business.exception.CorreoMqttExecutionException;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.services.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishService.class);
    private final MessageDTO messageDTO;

    public PublishService(String connectionId, MessageDTO messageDTO) {
        super(connectionId);
        this.messageDTO = messageDTO;
    }

    public void publish() {
        LOGGER.info(this.getConnectionMarker(), "Start publishing to topic: {}", (Object)this.messageDTO.getTopic());
        this.callSafeOnClient(client -> {
            try {
                client.publish(this.messageDTO);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CorreoMqttExecutionException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new CorreoMqttExecutionException(e);
            }
        });
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Publish to {} succeeded.", (Object)this.messageDTO.getTopic());
        PublishDispatcher.getInstance().onPublishSucceeded(this.connectionId, this.messageDTO);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Publish to {} cancelled.", (Object)this.messageDTO.getTopic());
        PublishDispatcher.getInstance().onPublishCancelled(this.connectionId, this.messageDTO);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.warn(this.getConnectionMarker(), "Publish to {} failed: ", (Object)this.messageDTO.getTopic(), (Object)exception);
        PublishDispatcher.getInstance().onPublishFailed(this.connectionId, this.messageDTO, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.debug(this.getConnectionMarker(), "Publish to {} running", (Object)this.messageDTO.getTopic());
        PublishDispatcher.getInstance().onPublishRunning(this.connectionId, this.messageDTO);
    }

    @Override
    public void onScheduled() {
        LOGGER.debug(this.getConnectionMarker(), "Publish to {} scheduled", (Object)this.messageDTO.getTopic());
        PublishDispatcher.getInstance().onPublishScheduled(this.connectionId, this.messageDTO);
    }
}

