/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.correomqtt.business.dispatcher.SubscribeDispatcher;
import org.correomqtt.business.exception.CorreoMqttExecutionException;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.SubscriptionDTO;
import org.correomqtt.business.mqtt.CorreoMqttClient;
import org.correomqtt.business.services.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribeService.class);
    private final SubscriptionDTO subscriptionDTO;

    public SubscribeService(String connectionId, SubscriptionDTO subscriptionDTO) {
        super(connectionId);
        this.subscriptionDTO = subscriptionDTO;
    }

    public void subscribe() {
        assert (!this.subscriptionDTO.getTopic().isEmpty());
        this.callSafeOnClient(client -> this.subscribe(client, this.subscriptionDTO));
    }

    private void subscribe(CorreoMqttClient client, SubscriptionDTO subscriptionDTO) {
        try {
            client.subscribe(subscriptionDTO, (MessageDTO messageDTO) -> SubscribeDispatcher.getInstance().onMessageIncoming(this.connectionId, (MessageDTO)messageDTO, subscriptionDTO));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CorreoMqttExecutionException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CorreoMqttExecutionException(e);
        }
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Successful subscription to {}", (Object)this.subscriptionDTO.getTopic());
        SubscribeDispatcher.getInstance().onSubscribedSucceeded(this.connectionId, this.subscriptionDTO);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Subscription to {} cancelled", (Object)this.subscriptionDTO.getTopic());
        SubscribeDispatcher.getInstance().onSubscribedCanceled(this.connectionId, this.subscriptionDTO);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.info(this.getConnectionMarker(), "Subscription to {} failed", (Object)this.subscriptionDTO.getTopic(), (Object)exception);
        SubscribeDispatcher.getInstance().onSubscribedFailed(this.connectionId, this.subscriptionDTO, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.debug(this.getConnectionMarker(), "Subscription to {} running.", (Object)this.subscriptionDTO.getTopic());
        SubscribeDispatcher.getInstance().onSubscribedRunning(this.connectionId, this.subscriptionDTO);
    }

    @Override
    public void onScheduled() {
        LOGGER.debug(this.getConnectionMarker(), "Subscription to {} scheduled.", (Object)this.subscriptionDTO.getTopic());
        SubscribeDispatcher.getInstance().onSubscribedScheduled(this.connectionId, this.subscriptionDTO);
    }
}

