/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.services;

import org.correomqtt.business.dispatcher.UnsubscribeDispatcher;
import org.correomqtt.business.model.SubscriptionDTO;
import org.correomqtt.business.services.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsubscribeService
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsubscribeService.class);
    private final SubscriptionDTO subscriptionDTO;

    public UnsubscribeService(String connectionId, SubscriptionDTO subscriptionDTO) {
        super(connectionId);
        this.subscriptionDTO = subscriptionDTO;
    }

    public void unsubscribe() {
        LOGGER.info(this.getConnectionMarker(), "Start unsubscribing to topic: {}", (Object)this.subscriptionDTO.getTopic());
        this.callSafeOnClient(client -> client.unsubscribe(this.subscriptionDTO));
    }

    @Override
    public void onSucceeded() {
        LOGGER.info(this.getConnectionMarker(), "Successfully unsubscribed from {}.", (Object)this.subscriptionDTO.getTopic());
        UnsubscribeDispatcher.getInstance().onUnsubscribeSucceeded(this.connectionId, this.subscriptionDTO);
    }

    @Override
    public void onCancelled() {
        LOGGER.info(this.getConnectionMarker(), "Unsubscribe from {} cancelled.", (Object)this.subscriptionDTO.getTopic());
        UnsubscribeDispatcher.getInstance().onUnsubscribeCanceled(this.connectionId, this.subscriptionDTO);
    }

    @Override
    public void onFailed(Throwable exception) {
        LOGGER.warn(this.getConnectionMarker(), "Unsubscribe from {} failed: ", (Object)this.subscriptionDTO.getTopic(), (Object)exception);
        UnsubscribeDispatcher.getInstance().onUnsubscribeFailed(this.connectionId, this.subscriptionDTO, exception);
    }

    @Override
    public void onRunning() {
        LOGGER.debug(this.getConnectionMarker(), "Unsubscribe from {} running.", (Object)this.subscriptionDTO.getTopic());
        UnsubscribeDispatcher.getInstance().onUnsubscribeRunning(this.connectionId, this.subscriptionDTO);
    }

    @Override
    public void onScheduled() {
        LOGGER.debug(this.getConnectionMarker(), "Unsubscribe from {} scheduled.", (Object)this.subscriptionDTO.getTopic());
        UnsubscribeDispatcher.getInstance().onUnsubscribeScheduled(this.connectionId, this.subscriptionDTO);
    }
}

