/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.business.utils;

import java.util.ArrayList;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import org.correomqtt.gui.formats.Format;
import org.correomqtt.gui.formats.Plain;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.spi.DetailViewFormatHook;
import org.fxmisc.richtext.CodeArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoFormatPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoFormatPayload.class);

    private AutoFormatPayload() {
    }

    public static Format autoFormatPayload(String payload, boolean doFormatting, String connectionId, CodeArea codeArea) {
        return AutoFormatPayload.autoFormatPayload(payload, doFormatting, connectionId, codeArea, null);
    }

    public static Format autoFormatPayload(String payload, boolean doFormatting, String connectionId, CodeArea codeArea, ChangeListener<String> listener) {
        Format foundFormat;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Auto formatting payload: {}", (Object)connectionId);
        }
        if (doFormatting) {
            ArrayList<DetailViewFormatHook> availableFormats = new ArrayList<DetailViewFormatHook>(PluginManager.getInstance().getExtensions(DetailViewFormatHook.class));
            availableFormats.add((DetailViewFormatHook)((Object)new Plain()));
            foundFormat = availableFormats.stream().filter(Objects::nonNull).filter(format -> {
                try {
                    format.setText(payload);
                    return format.isValid();
                }
                catch (Exception e) {
                    LOGGER.error("Formatting check failed. ", (Throwable)e);
                    return false;
                }
            }).findFirst().orElseThrow(() -> new IllegalArgumentException("Plain format did not match."));
        } else {
            foundFormat = new Plain();
            foundFormat.setText(payload);
        }
        if (listener != null) {
            codeArea.textProperty().removeListener(listener);
        }
        codeArea.clear();
        try {
            codeArea.replaceText(0, 0, foundFormat.getPrettyString());
            codeArea.setStyleSpans(0, foundFormat.getFxSpans());
        }
        catch (Exception e) {
            LOGGER.error("Formatter failed. ", (Throwable)e);
            foundFormat = new Plain();
            foundFormat.setText(payload);
            codeArea.replaceText(0, 0, foundFormat.getPrettyString());
            codeArea.setStyleSpans(0, foundFormat.getFxSpans());
        }
        if (listener != null) {
            codeArea.textProperty().addListener(listener);
        }
        return foundFormat;
    }
}

