/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import org.correomqtt.business.model.CorreoMqttVersion;
import org.correomqtt.business.model.Lwt;
import org.correomqtt.business.model.Proxy;
import org.correomqtt.business.model.TlsSsl;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.cell.SubscriptionViewCell;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionCell
extends ListCell<ConnectionPropertiesDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionCell.class);
    public static final String DIRTY_CLASS = "dirty";
    public static final String INACTIVE_CLASS = "inactive";
    private final ListView<ConnectionPropertiesDTO> listView;
    @FXML
    private Pane mainNode;
    @FXML
    private Label nameLabel;
    @FXML
    private Label descriptionLabel;
    @FXML
    private Label credentialsTag;
    @FXML
    private Label sslTag;
    @FXML
    private Label proxyTag;
    @FXML
    private Label lwtTag;
    @FXML
    private Label mqtt3Tag;
    @FXML
    private Label mqtt5Tag;
    @FXML
    private ResourceBundle resources;
    private FXMLLoader loader;

    @FXML
    public void initialize() {
        this.mainNode.getStyleClass().add((Object)SettingsProvider.getInstance().getIconModeCssClass());
    }

    public ConnectionCell(ListView<ConnectionPropertiesDTO> listView) {
        this.listView = listView;
    }

    protected void updateItem(ConnectionPropertiesDTO connectionDTO, boolean empty) {
        super.updateItem((Object)connectionDTO, empty);
        if (empty || connectionDTO == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(SubscriptionViewCell.class.getResource("connectionView.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception rendering connection:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            this.setConnection(connectionDTO);
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }

    private void setConnection(ConnectionPropertiesDTO connectionDTO) {
        if (connectionDTO.isDirty()) {
            this.nameLabel.setText(connectionDTO.getName() + " *");
            this.nameLabel.getStyleClass().removeAll((Object[])new String[]{DIRTY_CLASS});
            this.nameLabel.getStyleClass().add((Object)DIRTY_CLASS);
            this.descriptionLabel.getStyleClass().removeAll((Object[])new String[]{DIRTY_CLASS});
            this.descriptionLabel.getStyleClass().add((Object)DIRTY_CLASS);
            this.mqtt3Tag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.mqtt3Tag.getStyleClass().add((Object)INACTIVE_CLASS);
            this.mqtt5Tag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.mqtt5Tag.getStyleClass().add((Object)INACTIVE_CLASS);
            this.credentialsTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.credentialsTag.getStyleClass().add((Object)INACTIVE_CLASS);
            this.sslTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.sslTag.getStyleClass().add((Object)INACTIVE_CLASS);
            this.proxyTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.proxyTag.getStyleClass().add((Object)INACTIVE_CLASS);
            this.lwtTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.lwtTag.getStyleClass().add((Object)INACTIVE_CLASS);
        } else {
            this.nameLabel.setText(connectionDTO.getName());
            this.nameLabel.getStyleClass().removeAll((Object[])new String[]{DIRTY_CLASS});
            this.descriptionLabel.getStyleClass().removeAll((Object[])new String[]{DIRTY_CLASS});
            this.mqtt3Tag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.mqtt5Tag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.credentialsTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.sslTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.proxyTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
            this.lwtTag.getStyleClass().removeAll((Object[])new String[]{INACTIVE_CLASS});
        }
        this.descriptionLabel.setText(connectionDTO.getHostAndPort());
        boolean mqtt3 = ((CorreoMqttVersion)connectionDTO.getMqttVersionProperty().getValue()).equals(CorreoMqttVersion.MQTT_3_1_1);
        this.mqtt3Tag.setVisible(mqtt3);
        this.mqtt3Tag.setManaged(mqtt3);
        boolean mqtt5 = ((CorreoMqttVersion)connectionDTO.getMqttVersionProperty().getValue()).equals(CorreoMqttVersion.MQTT_5_0);
        this.mqtt5Tag.setVisible(mqtt5);
        this.mqtt5Tag.setManaged(mqtt5);
        boolean credentials = connectionDTO.getUsername() != null && !connectionDTO.getUsername().isEmpty() && connectionDTO.getPassword() != null && !connectionDTO.getPassword().isEmpty();
        this.credentialsTag.setVisible(credentials);
        this.credentialsTag.setManaged(credentials);
        boolean ssl = ((TlsSsl)connectionDTO.getSslProperty().getValue()).equals(TlsSsl.KEYSTORE);
        this.sslTag.setVisible(ssl);
        this.sslTag.setManaged(ssl);
        boolean proxy = ((Proxy)connectionDTO.getProxyProperty().getValue()).equals(Proxy.SSH);
        this.proxyTag.setVisible(proxy);
        this.proxyTag.setManaged(proxy);
        boolean lwt = ((Lwt)connectionDTO.getLwtProperty().getValue()).equals(Lwt.ON);
        this.lwtTag.setVisible(lwt);
        this.lwtTag.setManaged(lwt);
    }
}

