/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.cell;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.Pane;
import org.correomqtt.business.provider.SettingsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicCell
extends ListCell<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicCell.class);
    private final ListView<String> listView;
    @FXML
    private Pane mainNode;
    @FXML
    private Label topicLabel;
    @FXML
    private ResourceBundle resources;
    private FXMLLoader loader;

    public TopicCell(ListView<String> listView) {
        this.listView = listView;
    }

    protected void updateItem(String topic, boolean empty) {
        super.updateItem((Object)topic, empty);
        if (empty || topic == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.loader == null) {
                try {
                    this.loader = new FXMLLoader(TopicCell.class.getResource("topicCell.fxml"), ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale()));
                    this.loader.setController((Object)this);
                    this.loader.load();
                }
                catch (Exception e) {
                    LOGGER.error("Exception rendering topic cell:", (Throwable)e);
                    this.setText(this.resources.getString("commonRowCreationError"));
                    this.setGraphic(null);
                    return;
                }
            }
            this.mainNode.prefWidthProperty().bind((ObservableValue)this.listView.widthProperty().subtract(20));
            this.setTopic(topic);
            this.setText(null);
            this.setGraphic((Node)this.mainNode);
        }
    }

    private void setTopic(String topic) {
        this.topicLabel.setText(topic);
    }
}

