/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.contextmenu;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.scene.control.MenuItem;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.contextmenu.BaseMessageContextMenuDelegate;
import org.correomqtt.gui.contextmenu.BaseObjectContextMenu;
import org.correomqtt.gui.helper.ClipboardHelper;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseMessageContextMenu<D extends BaseMessageContextMenuDelegate>
extends BaseObjectContextMenu<MessagePropertiesDTO, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMessageContextMenu.class);
    protected MenuItem putToForm;
    protected MenuItem showDetails;
    protected MenuItem copyTopicToClipboard;
    protected MenuItem copyTimeToClipboard;
    protected MenuItem copyPayloadToClipboard;
    private ResourceBundle resources;

    BaseMessageContextMenu(D dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void initializeItems() {
        this.resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
        super.initializeItems();
        this.putToForm = new MenuItem(this.resources.getString("baseMessageContextMenuPutToFormMenuItem"));
        this.putToForm.setOnAction(this::putToForm);
        this.showDetails = new MenuItem(this.resources.getString("baseMessageContextMenuShowDetailsMenuItem"));
        this.showDetails.setOnAction(this::showDetails);
        this.copyTopicToClipboard = new MenuItem(this.resources.getString("baseMessageContextMenuTopicMenuItem"));
        this.copyTopicToClipboard.setOnAction(this::copyTopicToClipboard);
        this.copyTimeToClipboard = new MenuItem(this.resources.getString("baseMessageContextMenuTimeMenuItem"));
        this.copyTimeToClipboard.setOnAction(this::copyTimeToClipboard);
        this.copyPayloadToClipboard = new MenuItem(this.resources.getString("baseMessageContextMenuPayloadMenuItem"));
        this.copyPayloadToClipboard.setOnAction(this::copyPayloadToClipoard);
    }

    @Override
    protected void setVisibilityForObjectItems(boolean visible) {
        super.setVisibilityForObjectItems(visible);
        this.putToForm.setVisible(visible);
        this.showDetails.setVisible(visible);
        this.copyTopicToClipboard.setVisible(visible);
        this.copyTimeToClipboard.setVisible(visible);
        this.copyPayloadToClipboard.setVisible(visible);
    }

    private void showDetails(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((BaseMessageContextMenuDelegate)this.delegate).showDetailsInSeparateWindow((MessagePropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::showDetails with empty message.", (Object)this.getClassName());
        }
    }

    private void copyPayloadToClipoard(ActionEvent actionEvent) {
        if (this.dto != null) {
            ClipboardHelper.addToClipboard(((MessagePropertiesDTO)this.dto).getPayload());
        } else {
            LOGGER.warn("Call to {}::copyPayloadToClipoard with empty message.", (Object)this.getClassName());
        }
    }

    private void copyTimeToClipboard(ActionEvent actionEvent) {
        if (this.dto != null) {
            ClipboardHelper.addToClipboard(((MessagePropertiesDTO)this.dto).getDateTime().toString());
        } else {
            LOGGER.warn("Call to {}::copyTimeToClipboard with empty message.", (Object)this.getClassName());
        }
    }

    private void copyTopicToClipboard(ActionEvent actionEvent) {
        if (this.dto != null) {
            ClipboardHelper.addToClipboard(((MessagePropertiesDTO)this.dto).getTopic());
        } else {
            LOGGER.warn("Call to {}::copyTopicToClipboard with empty message.", (Object)this.getClassName());
        }
    }

    private void putToForm(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((BaseMessageContextMenuDelegate)this.delegate).setUpToForm((MessagePropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::putToForm with empty message.", (Object)this.getClassName());
        }
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public void setResources(ResourceBundle resources) {
        this.resources = resources;
    }
}

