/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.contextmenu;

import javafx.event.ActionEvent;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.correomqtt.gui.contextmenu.BaseMessageContextMenu;
import org.correomqtt.gui.contextmenu.MessageListContextMenuDelegate;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListContextMenu
extends BaseMessageContextMenu<MessageListContextMenuDelegate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListContextMenu.class);
    private MenuItem removeMessage;
    private MenuItem saveMessage;
    private MenuItem timeInfo;
    private SeparatorMenuItem separator1;
    private SeparatorMenuItem separator2;
    private SeparatorMenuItem separator3;

    public MessageListContextMenu(MessageListContextMenuDelegate dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void initializeItems() {
        super.initializeItems();
        this.removeMessage = new MenuItem(this.getResources().getString("messageListContextMenuRemoveMenuItem"));
        this.removeMessage.setOnAction(this::removeMessage);
        this.saveMessage = new MenuItem(this.getResources().getString("messageListContextMenuSaveMenuItem"));
        this.saveMessage.setOnAction(this::saveMessage);
        this.timeInfo = new MenuItem();
        this.timeInfo.setVisible(false);
        this.timeInfo.setDisable(true);
        MenuItem clearList = new MenuItem(this.getResources().getString("messageListContextMenuClearMenuItem"));
        clearList.setOnAction(this::clearList);
        this.separator1 = new SeparatorMenuItem();
        this.separator2 = new SeparatorMenuItem();
        this.separator3 = new SeparatorMenuItem();
        this.getItems().addAll((Object[])new MenuItem[]{this.putToForm, this.showDetails, this.removeMessage, this.saveMessage, this.separator1, this.copyTopicToClipboard, this.copyTimeToClipboard, this.copyPayloadToClipboard, this.separator2, this.timeInfo, this.separator3, clearList});
        this.updateDateTime();
    }

    private void saveMessage(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((MessageListContextMenuDelegate)this.delegate).saveMessage((MessagePropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::saveMessage with empty message.", (Object)this.getClassName());
        }
    }

    @Override
    public void setObject(MessagePropertiesDTO messageDTO) {
        super.setObject(messageDTO);
        if (messageDTO != null) {
            messageDTO.getDateTimeProperty().addListener((observable, oldValue, newValue) -> this.updateDateTime());
        }
        this.updateDateTime();
    }

    @Override
    protected void setVisibilityForObjectItems(boolean visible) {
        super.setVisibilityForObjectItems(visible);
        this.removeMessage.setVisible(visible);
        this.saveMessage.setVisible(visible);
        this.separator1.setVisible(visible);
        this.separator2.setVisible(visible);
        this.separator3.setVisible(visible);
    }

    private void updateDateTime() {
        if (this.dto != null && ((MessagePropertiesDTO)this.dto).getDateTime() != null) {
            this.timeInfo.setVisible(true);
            this.timeInfo.setText(((MessagePropertiesDTO)this.dto).getDateTime().toString());
        } else {
            this.timeInfo.setVisible(false);
            this.timeInfo.setText("");
        }
    }

    private void clearList(ActionEvent actionEvent) {
        ((MessageListContextMenuDelegate)this.delegate).clearList();
    }

    private void removeMessage(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((MessageListContextMenuDelegate)this.delegate).removeMessage((MessagePropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::removeMessage with empty message.", (Object)this.getClassName());
        }
    }
}

