/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.contextmenu;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.contextmenu.BaseObjectContextMenu;
import org.correomqtt.gui.contextmenu.SubscriptionListMessageContextMenuDelegate;
import org.correomqtt.gui.model.SubscriptionPropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionListMessageContextMenu
extends BaseObjectContextMenu<SubscriptionPropertiesDTO, SubscriptionListMessageContextMenuDelegate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionListMessageContextMenu.class);
    private MenuItem unsubscribe;
    private MenuItem filter;
    private MenuItem filterOnly;
    private SeparatorMenuItem separator1;

    public SubscriptionListMessageContextMenu(SubscriptionListMessageContextMenuDelegate dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void initializeItems() {
        ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
        super.initializeItems();
        this.unsubscribe = new MenuItem("Unsubscribe");
        this.unsubscribe.setOnAction(this::unsubcribe);
        this.filter = new MenuItem("Toggle Filter");
        this.filter.setOnAction(this::toggleFilter);
        this.filterOnly = new MenuItem(resources.getString("subscriptionListMessageContextMenuFilterOnlyMenuItem"));
        this.filterOnly.setOnAction(this::filterOnly);
        MenuItem selectAll = new MenuItem(resources.getString("subscriptionListMessageContextMenuSelectAllMenuItem"));
        selectAll.setOnAction(this::selectAll);
        MenuItem selectNone = new MenuItem(resources.getString("subscriptionListMessageContextMenuSelectNoneMenuItem"));
        selectNone.setOnAction(this::selectNone);
        MenuItem unsubscribeAll = new MenuItem(resources.getString("subscriptionListMessageContextMenuUnsubscribeAllMenuItem"));
        unsubscribeAll.setOnAction(this::unsubscribeAll);
        this.separator1 = new SeparatorMenuItem();
        SeparatorMenuItem separator2 = new SeparatorMenuItem();
        this.getItems().addAll((Object[])new MenuItem[]{this.unsubscribe, this.filter, this.filterOnly, this.separator1, selectAll, selectNone, separator2, unsubscribeAll});
    }

    @Override
    protected void setVisibilityForObjectItems(boolean visible) {
        super.setVisibilityForObjectItems(visible);
        this.unsubscribe.setVisible(visible);
        this.filter.setVisible(visible);
        this.filterOnly.setVisible(visible);
        this.separator1.setVisible(visible);
    }

    private void unsubscribeAll(ActionEvent actionEvent) {
        ((SubscriptionListMessageContextMenuDelegate)this.delegate).unsubscribeAll();
    }

    private void selectNone(ActionEvent actionEvent) {
        ((SubscriptionListMessageContextMenuDelegate)this.delegate).selectNone();
    }

    private void selectAll(ActionEvent actionEvent) {
        ((SubscriptionListMessageContextMenuDelegate)this.delegate).selectAll();
    }

    private void filterOnly(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((SubscriptionListMessageContextMenuDelegate)this.delegate).filterOnly((SubscriptionPropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::filterOnly with empty message.", (Object)this.getClassName());
        }
    }

    private void toggleFilter(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((SubscriptionPropertiesDTO)this.dto).setFiltered(!((SubscriptionPropertiesDTO)this.dto).isFiltered());
        } else {
            LOGGER.warn("Call to {}::toggleFilter with empty message.", (Object)this.getClassName());
        }
    }

    private void unsubcribe(ActionEvent actionEvent) {
        if (this.dto != null) {
            ((SubscriptionListMessageContextMenuDelegate)this.delegate).unsubscribe((SubscriptionPropertiesDTO)this.dto);
        } else {
            LOGGER.warn("Call to {}::unsubcribe with empty message.", (Object)this.getClassName());
        }
    }
}

