/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import org.correomqtt.business.utils.VersionUtils;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.utils.HostServicesHolder;
import org.correomqtt.gui.utils.WindowHelper;

public class AboutViewController
extends BaseController {
    List<Hyperlink> links = new ArrayList<Hyperlink>();
    @FXML
    private Hyperlink hiveMqttClientRepo;
    @FXML
    private Hyperlink hiveMqttClientLicense;
    @FXML
    private Hyperlink jsonSimpleRepo;
    @FXML
    private Hyperlink jsonSimpleLicense;
    @FXML
    private Hyperlink jacksonDatabindRepo;
    @FXML
    private Hyperlink jacksonDatabindLicense;
    @FXML
    private Hyperlink gsonRepo;
    @FXML
    private Hyperlink gsonLicense;
    @FXML
    private Hyperlink richTextFXRepo;
    @FXML
    private Hyperlink richTextFXLicense;
    @FXML
    private Hyperlink flowlessRepo;
    @FXML
    private Hyperlink flowlessLicense;
    @FXML
    private Hyperlink lombokRepo;
    @FXML
    private Hyperlink lombokLicense;
    @FXML
    private Hyperlink langRepo;
    @FXML
    private Hyperlink langLicense;
    @FXML
    private Hyperlink ioRepo;
    @FXML
    private Hyperlink ioLicense;
    @FXML
    private Hyperlink logbackRepo;
    @FXML
    private Hyperlink logbackLicense;
    @FXML
    private Hyperlink sshjRepo;
    @FXML
    private Hyperlink sshjLicense;
    @FXML
    private Hyperlink javaKeyring;
    @FXML
    private Hyperlink javaKeyringLicense;
    @FXML
    private Hyperlink secretService;
    @FXML
    private Hyperlink secretServiceLicense;
    @FXML
    private Hyperlink windpapi4j;
    @FXML
    private Hyperlink windpapi4jLicense;
    @FXML
    private Hyperlink fontAwesomeRepo;
    @FXML
    private Hyperlink fontAwesomeLicense;
    @FXML
    private Hyperlink exxetaLink;
    @FXML
    private Label appNameLabel;

    public static LoaderResult<AboutViewController> load() {
        return AboutViewController.load(AboutViewController.class, "aboutView.fxml");
    }

    public static void showAsDialog() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.ABOUT);
        if (WindowHelper.focusWindowIfAlreadyThere(properties)) {
            return;
        }
        LoaderResult<AboutViewController> result = AboutViewController.load();
        ResourceBundle resources = result.getResourceBundle();
        AboutViewController.showAsDialog(result, resources.getString("aboutViewControllerTitle"), properties, false, false, null, null);
    }

    @FXML
    public void initialize() {
        this.appNameLabel.setText("CorreoMQTT v" + VersionUtils.getVersion());
        this.hiveMqttClientRepo.getProperties().put((Object)"link", (Object)"https://github.com/hivemq/hivemq-mqtt-client/tree/v1.1.1");
        this.hiveMqttClientLicense.getProperties().put((Object)"link", (Object)"https://github.com/hivemq/hivemq-mqtt-client/blob/v1.1.1/LICENSE");
        this.jsonSimpleRepo.getProperties().put((Object)"link", (Object)"https://github.com/fangyidong/json-simple/tree/tag_release_1_1_1");
        this.jsonSimpleLicense.getProperties().put((Object)"link", (Object)"https://github.com/fangyidong/json-simple/blob/tag_release_1_1_1/LICENSE.txt");
        this.jacksonDatabindRepo.getProperties().put((Object)"link", (Object)"https://github.com/FasterXML/jackson-databind/tree/jackson-databind-2.9.7");
        this.jacksonDatabindLicense.getProperties().put((Object)"link", (Object)"https://github.com/FasterXML/jackson-databind/blob/jackson-databind-2.9.7/src/main/resources/META-INF/LICENSE");
        this.gsonRepo.getProperties().put((Object)"link", (Object)"https://github.com/google/gson/tree/gson-parent-2.8.5");
        this.gsonLicense.getProperties().put((Object)"link", (Object)"https://github.com/google/gson/blob/gson-parent-2.8.5/LICENSE");
        this.richTextFXRepo.getProperties().put((Object)"link", (Object)"https://github.com/FXMisc/RichTextFX/tree/v0.9.3");
        this.richTextFXLicense.getProperties().put((Object)"link", (Object)"https://github.com/FXMisc/RichTextFX/blob/v0.9.3/LICENSE");
        this.flowlessRepo.getProperties().put((Object)"link", (Object)"https://github.com/FXMisc/Flowless/tree/v0.6.1");
        this.flowlessLicense.getProperties().put((Object)"link", (Object)"https://github.com/FXMisc/Flowless/blob/v0.6.1/LICENSE");
        this.lombokRepo.getProperties().put((Object)"link", (Object)"https://projectlombok.org/");
        this.lombokLicense.getProperties().put((Object)"link", (Object)"https://projectlombok.org/LICENSE");
        this.langRepo.getProperties().put((Object)"link", (Object)"https://github.com/apache/commons-lang/tree/LANG_3_8");
        this.langLicense.getProperties().put((Object)"link", (Object)"https://github.com/apache/commons-lang/blob/LANG_3_8/NOTICE.txt");
        this.ioRepo.getProperties().put((Object)"link", (Object)"https://github.com/apache/commons-io");
        this.ioLicense.getProperties().put((Object)"link", (Object)"https://github.com/apache/commons-io/blob/master/NOTICE.txt");
        this.logbackRepo.getProperties().put((Object)"link", (Object)"https://github.com/qos-ch/logback/tree/v_1.2.3");
        this.logbackLicense.getProperties().put((Object)"link", (Object)"https://github.com/qos-ch/logback/blob/v_1.2.3/LICENSE.txt");
        this.sshjRepo.getProperties().put((Object)"link", (Object)"https://github.com/hierynomus/sshj/tree/v0.27.0");
        this.sshjLicense.getProperties().put((Object)"link", (Object)"https://github.com/hierynomus/sshj/blob/v0.27.0/LICENSE_HEADER");
        this.javaKeyring.getProperties().put((Object)"link", (Object)"https://github.com/xafero/java-keyring/tree/6c9004414013c06dd54f7e4e96f19f1821ace67d");
        this.javaKeyringLicense.getProperties().put((Object)"link", (Object)"https://github.com/xafero/java-keyring/blob/6c9004414013c06dd54f7e4e96f19f1821ace67d/LICENSE");
        this.secretService.getProperties().put((Object)"link", (Object)"https://github.com/swiesend/secret-service/tree/v1.0.0");
        this.secretServiceLicense.getProperties().put((Object)"link", (Object)"https://github.com/swiesend/secret-service/blob/v1.0.0/LICENSE");
        this.windpapi4j.getProperties().put((Object)"link", (Object)"https://github.com/peter-gergely-horvath/windpapi4j/tree/1.0");
        this.windpapi4jLicense.getProperties().put((Object)"link", (Object)"https://github.com/peter-gergely-horvath/windpapi4j/blob/1.0/LICENSE");
        this.fontAwesomeRepo.getProperties().put((Object)"link", (Object)"https://github.com/FortAwesome/Font-Awesome");
        this.fontAwesomeLicense.getProperties().put((Object)"link", (Object)"https://fontawesome.com/license/free");
        this.exxetaLink.getProperties().put((Object)"link", (Object)"https://www.exxeta.com");
        this.links.addAll(Arrays.asList(this.hiveMqttClientRepo, this.hiveMqttClientLicense, this.jsonSimpleRepo, this.jsonSimpleLicense, this.jacksonDatabindRepo, this.jacksonDatabindLicense, this.gsonRepo, this.gsonLicense, this.richTextFXRepo, this.richTextFXLicense, this.flowlessRepo, this.flowlessLicense, this.lombokRepo, this.lombokLicense, this.langRepo, this.langLicense, this.ioRepo, this.ioLicense, this.logbackRepo, this.logbackLicense, this.sshjRepo, this.sshjLicense, this.javaKeyring, this.javaKeyringLicense, this.secretService, this.secretServiceLicense, this.windpapi4j, this.windpapi4jLicense, this.fontAwesomeRepo, this.fontAwesomeLicense, this.exxetaLink));
        for (Hyperlink hyperlink : this.links) {
            hyperlink.setOnAction(t -> HostServicesHolder.getInstance().getHostServices().showDocument(hyperlink.getProperties().get((Object)"link").toString()));
        }
    }
}

