/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ResourceBundle;
import org.correomqtt.business.dispatcher.ConfigDispatcher;
import org.correomqtt.business.dispatcher.ConfigObserver;
import org.correomqtt.business.dispatcher.PersistPublishHistoryDispatcher;
import org.correomqtt.business.dispatcher.PersistPublishHistoryObserver;
import org.correomqtt.business.dispatcher.PersistSubscriptionHistoryDispatcher;
import org.correomqtt.business.dispatcher.PersistSubscriptionHistoryObserver;
import org.correomqtt.business.dispatcher.SecretStoreDispatcher;
import org.correomqtt.business.dispatcher.SecretStoreObserver;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.utils.PlatformUtils;

public class AlertController
extends BaseController
implements ConfigObserver,
SecretStoreObserver,
PersistPublishHistoryObserver,
PersistSubscriptionHistoryObserver {
    public static final String ALERT_CONTROLLER_WARN_TITLE = "alertControllerWarnTitle";
    public static final String ALERT_EXCEPTION_TITLE = "Exception";
    private final ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
    private static AlertController instance;

    private AlertController() {
        ConfigDispatcher.getInstance().addObserver(this);
        SecretStoreDispatcher.getInstance().addObserver(this);
        PersistPublishHistoryDispatcher.getInstance().addObserver(this);
        PersistSubscriptionHistoryDispatcher.getInstance().addObserver(this);
    }

    public static void activate() {
        if (instance == null) {
            instance = new AlertController();
        }
    }

    @Override
    public void onConfigDirectoryEmpty() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString(ALERT_CONTROLLER_WARN_TITLE), this.resources.getString("alertControllerOnConfigDirectoryEmptyContent")));
    }

    @Override
    public void onConfigDirectoryNotAccessible() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString(ALERT_CONTROLLER_WARN_TITLE), this.resources.getString("alertControllerOnConfigDirectoryNotAccessibleContent")));
    }

    @Override
    public void onAppDataNull() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString(ALERT_CONTROLLER_WARN_TITLE), this.resources.getString("alertControllerOnAppDataNullContent")));
    }

    @Override
    public void onUserHomeNull() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString(ALERT_CONTROLLER_WARN_TITLE), this.resources.getString("alertControllerOnUserHomeNullContent")));
    }

    @Override
    public void onFileAlreadyExists() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString("alertControllerOnFileAlreadyExistsTitle"), this.resources.getString("alertControllerOnFileAlreadyExistsContent")));
    }

    @Override
    public void onInvalidPath() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString("alertControllerOnInvalidPathTitle"), this.resources.getString("alertControllerOnInvalidPathContent")));
    }

    @Override
    public void onInvalidJsonFormat() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString("alertControllerOnInvalidJsonFormatTitle"), this.resources.getString("alertControllerOnInvalidJsonFormatContent")));
    }

    @Override
    public void onSavingFailed() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString("alertControllerOnSavingFailedTitle"), this.resources.getString("alertControllerOnSavingFailedContent")));
    }

    @Override
    public void onConnectionsUpdated() {
    }

    @Override
    public void onConfigPrepareFailed() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(ALERT_EXCEPTION_TITLE, this.resources.getString("alertControllerOnConfigPrepareFailedContent")));
    }

    @Override
    public void onSettingsUpdated(boolean showRestartRequiredDialog) {
        if (showRestartRequiredDialog) {
            PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.info(this.resources.getString("alertControllerOnSettingsUpdatedTitle"), this.resources.getString("alertControllerOnSettingsUpdatedContent")));
        }
    }

    @Override
    public void updateSubscriptions(String connectionId) {
    }

    @Override
    public void errorReadingSubscriptionHistory(Throwable exception) {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(ALERT_EXCEPTION_TITLE, this.resources.getString("alertControllerErrorReadingSubscriptionHistoryContent") + exception.getLocalizedMessage()));
    }

    @Override
    public String getConnectionId() {
        return null;
    }

    @Override
    public void errorReadingPublishHistory(Throwable exception) {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(ALERT_EXCEPTION_TITLE, this.resources.getString("alertControllerErrorReadingPublishHistoryContent") + exception.getLocalizedMessage()));
    }

    @Override
    public void errorWritingPublishHistory(Throwable exception) {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(ALERT_EXCEPTION_TITLE, this.resources.getString("alertControllerErrorWritingPublishHistoryContent") + exception.getLocalizedMessage()));
    }

    @Override
    public void updatedPublishes(String connectionId) {
    }

    @Override
    public void errorWritingSubscriptionHistory(Throwable exception) {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(ALERT_EXCEPTION_TITLE, this.resources.getString("alertControllerErrorWritingSubscriptionHistoryContent") + exception.getLocalizedMessage()));
    }

    @Override
    public void onPasswordFileUnreadable() {
        PlatformUtils.runLaterIfNotInFxThread(() -> AlertHelper.warn(this.resources.getString("onPasswordFileUnreadableFailedTitle"), this.resources.getString("onPasswordFileUnreadableFailedContent"), true));
    }
}

