/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import javafx.fxml.FXML;
import javafx.scene.control.SplitPane;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.MessageListViewController;
import org.correomqtt.gui.controller.MessageListViewDelegate;

abstract class BaseMessageBasedViewController
extends BaseConnectionController
implements MessageListViewDelegate {
    @FXML
    protected SplitPane splitPane;
    MessageListViewController messageListViewController;

    BaseMessageBasedViewController(String connectionId) {
        super(connectionId);
    }

    void initMessageListView() {
        LoaderResult<MessageListViewController> result = MessageListViewController.load(this.getConnectionId(), this);
        this.messageListViewController = result.getController();
        this.splitPane.getItems().add((Object)this.messageListViewController.getMainNode());
    }

    public double getDividerPosition() {
        if (!this.splitPane.getDividers().isEmpty()) {
            return ((SplitPane.Divider)this.splitPane.getDividers().get(0)).getPosition();
        }
        return 0.5;
    }

    public double getDetailDividerPosition() {
        return this.messageListViewController.getDetailDividerPosition();
    }

    public boolean isDetailActive() {
        return this.messageListViewController.isDetailActive();
    }

    @Override
    public void setConnectionId(String connectionId) {
        super.setConnectionId(connectionId);
        this.messageListViewController.setConnectionId(connectionId);
    }
}

