/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.File;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Pane;
import org.correomqtt.business.dispatcher.ConnectionLifecycleDispatcher;
import org.correomqtt.business.dispatcher.ConnectionLifecycleObserver;
import org.correomqtt.business.dispatcher.ExportMessageDispatcher;
import org.correomqtt.business.dispatcher.ExportMessageObserver;
import org.correomqtt.business.dispatcher.ImportMessageDispatcher;
import org.correomqtt.business.dispatcher.ImportMessageObserver;
import org.correomqtt.business.dispatcher.LogDispatcher;
import org.correomqtt.business.dispatcher.LogObserver;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.ConnectionUISettings;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.business.TaskFactory;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.ConnectionViewDelegate;
import org.correomqtt.gui.controller.ControlBarController;
import org.correomqtt.gui.controller.ControlBarDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.controller.LoadingViewController;
import org.correomqtt.gui.controller.PublishViewController;
import org.correomqtt.gui.controller.PublishViewDelegate;
import org.correomqtt.gui.controller.SubscriptionViewController;
import org.correomqtt.gui.controller.SubscriptionViewDelegate;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.keyring.KeyringHandler;
import org.correomqtt.gui.model.ConnectionPropertiesDTO;
import org.correomqtt.gui.model.ConnectionState;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionViewController
extends BaseConnectionController
implements LogObserver,
ConnectionLifecycleObserver,
ExportMessageObserver,
ImportMessageObserver,
PublishViewDelegate,
SubscriptionViewDelegate,
ControlBarDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionViewController.class);
    private final ConnectionViewDelegate delegate;
    @FXML
    private Pane connectionHolder;
    @FXML
    private SplitPane splitPane;
    private Pane publishPane;
    private Pane subscribePane;
    private LoadingViewController loadingViewController;
    private PublishViewController publishController;
    private ResourceBundle resources;
    private ConnectionConfigDTO connectionConfigDTO = null;
    private SubscriptionViewController subscribeController;

    public ConnectionViewController(String connectionId, ConnectionViewDelegate delegate) {
        super(connectionId);
        this.delegate = delegate;
        LogDispatcher.getInstance().addObserver(this);
        ConnectionLifecycleDispatcher.getInstance().addObserver(this);
        ExportMessageDispatcher.getInstance().addObserver(this);
        ImportMessageDispatcher.getInstance().addObserver(this);
    }

    public static LoaderResult<ConnectionViewController> load(String connectionId, ConnectionViewDelegate delegate) {
        return ConnectionViewController.load(ConnectionViewController.class, "connectionView.fxml", () -> new ConnectionViewController(connectionId, delegate));
    }

    @FXML
    public void initialize() {
        SettingsProvider.getInstance().getConnectionConfigs().stream().filter(c -> c.getId().equals(this.getConnectionId())).findFirst().ifPresent(c -> {
            this.connectionConfigDTO = c;
            if (this.connectionConfigDTO.getConnectionUISettings() == null) {
                this.connectionConfigDTO.setConnectionUISettings(new ConnectionUISettings(true, true, 0.5, 0.5, 0.5, false, 0.5, 0.5, false));
            }
        });
        LoaderResult<PublishViewController> publishLoadResult = PublishViewController.load(this.getConnectionId(), this);
        LoaderResult<SubscriptionViewController> subscriptionLoadResult = SubscriptionViewController.load(this.getConnectionId(), this);
        LoaderResult<ControlBarController> controlBarLoadResult = ControlBarController.load(this.getConnectionId(), this);
        this.publishPane = publishLoadResult.getMainPane();
        this.subscribePane = subscriptionLoadResult.getMainPane();
        Pane controlBarPane = controlBarLoadResult.getMainPane();
        this.publishController = publishLoadResult.getController();
        this.subscribeController = subscriptionLoadResult.getController();
        this.resources = controlBarLoadResult.getResourceBundle();
        this.connectionHolder.getChildren().add(0, (Object)controlBarPane);
        this.setLayout(this.connectionConfigDTO.getConnectionUISettings().isShowPublish(), this.connectionConfigDTO.getConnectionUISettings().isShowSubscribe());
        this.saveConnectionUISettings();
    }

    @Override
    public void saveConnectionUISettings() {
        LOGGER.debug("Save connection ui settings: {}", (Object)this.getConnectionId());
        if (!this.splitPane.getDividers().isEmpty()) {
            this.connectionConfigDTO.getConnectionUISettings().setMainDividerPosition(((SplitPane.Divider)this.splitPane.getDividers().get(0)).positionProperty().getValue());
            this.connectionConfigDTO.getConnectionUISettings().setShowPublish(true);
            this.connectionConfigDTO.getConnectionUISettings().setShowSubscribe(true);
        } else if (this.splitPane.getItems().contains((Object)this.publishPane)) {
            this.connectionConfigDTO.getConnectionUISettings().setShowPublish(true);
            this.connectionConfigDTO.getConnectionUISettings().setShowSubscribe(false);
        } else if (this.splitPane.getItems().contains((Object)this.subscribePane)) {
            this.connectionConfigDTO.getConnectionUISettings().setShowPublish(false);
            this.connectionConfigDTO.getConnectionUISettings().setShowSubscribe(true);
        }
        this.connectionConfigDTO.getConnectionUISettings().setPublishDividerPosition(this.publishController.getDividerPosition());
        this.connectionConfigDTO.getConnectionUISettings().setPublishDetailDividerPosition(this.publishController.getDetailDividerPosition());
        this.connectionConfigDTO.getConnectionUISettings().setPublishDetailActive(this.publishController.isDetailActive());
        this.connectionConfigDTO.getConnectionUISettings().setSubscribeDividerPosition(this.subscribeController.getDividerPosition());
        this.connectionConfigDTO.getConnectionUISettings().setSubscribeDetailDividerPosition(this.subscribeController.getDetailDividerPosition());
        this.connectionConfigDTO.getConnectionUISettings().setSubscribeDetailActive(this.subscribeController.isDetailActive());
        KeyringHandler.getInstance().retryWithMasterPassword(masterPassword -> SettingsProvider.getInstance().saveConnections(SettingsProvider.getInstance().getConnectionConfigs(), masterPassword), this.resources.getString("onPasswordSaveFailedTitle"), this.resources.getString("onPasswordSaveFailedHeader"), this.resources.getString("onPasswordSaveFailedContent"), this.resources.getString("onPasswordSaveFailedGiveUp"), this.resources.getString("onPasswordSaveFailedTryAgain"));
    }

    @Override
    public void resetConnectionUISettings() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reset connection ui settings': {}", (Object)this.getConnectionId());
        }
        this.setLayout(true, true);
        if (!this.splitPane.getDividers().isEmpty()) {
            ((SplitPane.Divider)this.splitPane.getDividers().get(0)).setPosition(0.5);
        }
        if (!this.publishController.splitPane.getDividers().isEmpty()) {
            ((SplitPane.Divider)this.publishController.splitPane.getDividers().get(0)).setPosition(0.5);
        }
        this.publishController.messageListViewController.showDetailViewButton.setSelected(false);
        this.publishController.messageListViewController.closeDetailView();
        if (!this.subscribeController.splitPane.getDividers().isEmpty()) {
            ((SplitPane.Divider)this.subscribeController.splitPane.getDividers().get(0)).setPosition(0.5);
        }
        this.subscribeController.messageListViewController.showDetailViewButton.setSelected(false);
        this.subscribeController.messageListViewController.closeDetailView();
    }

    @Override
    public void updateLog(String message) {
    }

    @Override
    public void setLayout(boolean publish, boolean subscribe) {
        if (publish && !subscribe) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Show only publish clicked': {}", (Object)this.getConnectionId());
            }
            this.setLayoutPublishOnly();
        } else if (!publish && subscribe) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Show only subscribe clicked': {}", (Object)this.getConnectionId());
            }
            this.setLayoutSubscribeOnly();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Show publish and subscribe clicked': {}", (Object)this.getConnectionId());
            }
            this.setLayoutBoth();
        }
    }

    private void setLayoutBoth() {
        if (!this.splitPane.getItems().contains((Object)this.subscribePane)) {
            this.splitPane.getItems().add((Object)this.subscribePane);
        }
        if (!this.splitPane.getItems().contains((Object)this.publishPane)) {
            this.splitPane.getItems().add(0, (Object)this.publishPane);
        }
        if (!this.splitPane.getDividers().isEmpty()) {
            ((SplitPane.Divider)this.splitPane.getDividers().get(0)).positionProperty().setValue((Number)this.connectionConfigDTO.getConnectionUISettings().getMainDividerPosition());
        }
    }

    private void setLayoutSubscribeOnly() {
        this.splitPane.getItems().remove((Object)this.publishPane);
        if (!this.splitPane.getItems().contains((Object)this.subscribePane)) {
            this.splitPane.getItems().add(0, (Object)this.subscribePane);
        }
    }

    private void setLayoutPublishOnly() {
        this.splitPane.getItems().remove((Object)this.subscribePane);
        if (!this.splitPane.getItems().contains((Object)this.publishPane)) {
            this.splitPane.getItems().add(0, (Object)this.publishPane);
        }
    }

    @Override
    public void onDisconnectFromConnectionDeleted(String connectionId) {
    }

    @Override
    public void onConnect() {
        Platform.runLater(() -> this.splitPane.setDisable(false));
    }

    @Override
    public void onConnectRunning() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onConnectionFailed(Throwable message) {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onConnectionCanceled() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onConnectionLost() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onDisconnect() {
        Platform.runLater(() -> this.splitPane.setDisable(true));
        this.delegate.onDisconnect();
    }

    @Override
    public void onConnectScheduled() {
    }

    @Override
    public void onDisconnectCanceled() {
    }

    @Override
    public void onDisconnectFailed(Throwable exception) {
    }

    @Override
    public void onDisconnectRunning() {
    }

    @Override
    public void onDisconnectScheduled() {
    }

    @Override
    public void onConnectionReconnected() {
        this.splitPane.setDisable(false);
    }

    @Override
    public void onReconnectFailed(AtomicInteger triedReconnects, int maxReconnects) {
    }

    public void disconnect() {
        this.saveConnectionUISettings();
        TaskFactory.disconnect(this.getConnectionId());
    }

    public Pane getMainNode() {
        return this.connectionHolder;
    }

    public void connect(ConnectionPropertiesDTO config) {
        this.splitPane.setDisable(true);
        this.setConnectionId(config.getId());
        TaskFactory.connect(this.getConnectionId());
    }

    @Override
    public void onExportStarted(File file, MessageDTO messageDTO) {
        Platform.runLater(() -> {
            this.splitPane.setDisable(true);
            this.loadingViewController = LoadingViewController.showAsDialog(this.getConnectionId(), this.resources.getString("connectionViewControllerExportTitle") + " " + file.getAbsolutePath());
        });
    }

    @Override
    public void onExportSucceeded() {
        this.disableLoading();
    }

    @Override
    public void onExportCancelled(File file, MessageDTO messageDTO) {
        this.disableLoading();
        AlertHelper.warn(this.resources.getString("connectionViewControllerExportCancelledTitle"), this.resources.getString("connectionViewControllerExportCancelledContent"));
    }

    @Override
    public void onExportFailed(File file, MessageDTO messageDTO, Throwable exception) {
        this.disableLoading();
        AlertHelper.warn(this.resources.getString("connectionViewControllerExportFailedTitle"), this.resources.getString("connectionViewControllerExportFailedContent") + exception.getLocalizedMessage());
    }

    @Override
    public void onExportRunning() {
    }

    @Override
    public void onExportScheduled() {
    }

    @Override
    public void onImportStarted(File file) {
        Platform.runLater(() -> this.splitPane.setDisable(true));
    }

    @Override
    public void onImportSucceeded(MessageDTO messageDTO) {
        this.disableLoading();
    }

    @Override
    public void onImportCancelled(File file) {
        this.disableLoading();
    }

    @Override
    public void onImportFailed(File file, Throwable exception) {
        this.disableLoading();
    }

    @Override
    public void onImportRunning() {
    }

    @Override
    public void onImportScheduled() {
    }

    private void disableLoading() {
        Platform.runLater(() -> {
            this.splitPane.setDisable(false);
            if (this.loadingViewController != null) {
                this.loadingViewController.close();
                this.loadingViewController = null;
            }
        });
    }

    @Override
    public void setUpToForm(MessagePropertiesDTO messageDTO) {
        if (this.publishController != null) {
            this.publishController.setUpToForm(messageDTO);
        }
    }

    @Override
    public void setConnectionState(ConnectionState state) {
        this.delegate.setConnectionState(this.getTabId(), state);
    }

    @Override
    public void setTabDirty() {
        this.delegate.setTabDirty(this.getTabId());
    }
}

