/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.correomqtt.business.dispatcher.ExportMessageDispatcher;
import org.correomqtt.business.dispatcher.ExportMessageObserver;
import org.correomqtt.business.dispatcher.ImportMessageDispatcher;
import org.correomqtt.business.dispatcher.ImportMessageObserver;
import org.correomqtt.business.model.MessageDTO;
import org.correomqtt.business.model.MessageType;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.business.utils.AutoFormatPayload;
import org.correomqtt.gui.contextmenu.DetailContextMenu;
import org.correomqtt.gui.contextmenu.DetailContextMenuDelegate;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.DetailViewDelegate;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.formats.Format;
import org.correomqtt.gui.formats.Plain;
import org.correomqtt.gui.menuitem.TaskMenuItem;
import org.correomqtt.gui.model.MessagePropertiesDTO;
import org.correomqtt.gui.model.Search;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.utils.MessageUtils;
import org.correomqtt.gui.utils.WindowHelper;
import org.correomqtt.plugin.manager.MessageValidator;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.manager.Task;
import org.correomqtt.plugin.model.MessageExtensionDTO;
import org.correomqtt.plugin.spi.DetailViewFormatHook;
import org.correomqtt.plugin.spi.DetailViewHook;
import org.correomqtt.plugin.spi.DetailViewManipulatorHook;
import org.correomqtt.plugin.spi.MessageValidatorHook;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailViewController
extends BaseConnectionController
implements DetailContextMenuDelegate,
ImportMessageObserver,
ExportMessageObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetailViewController.class);
    private static final String CHECK_SOLID_CLASS = "check-solid";
    private static ResourceBundle resources;
    private final BooleanProperty inlineViewProperty;
    private final DetailViewDelegate delegate;
    @FXML
    private Button detailViewSaveButton;
    @FXML
    private SplitMenuButton manipulateSelectionButton;
    @FXML
    private Button detailViewRevertManipulationButton;
    @FXML
    private Label detailViewTopicLabel;
    @FXML
    private Label detailViewTime;
    @FXML
    private HBox detailViewNodeBox;
    @FXML
    private Label detailViewValid;
    @FXML
    private Label detailViewInvalid;
    @FXML
    private Label detailViewRetained;
    @FXML
    private Label detailViewQos;
    @FXML
    private Pane detailViewScrollPane;
    @FXML
    private CodeArea codeArea;
    @FXML
    private VBox detailViewVBox;
    @FXML
    private HBox detailViewToolBar;
    @FXML
    private ToggleButton detailViewFormatToggleButton;
    @FXML
    private Button detailViewSearchButton;
    @FXML
    private HBox detailViewSearchHBox;
    @FXML
    private TextField searchTextField;
    @FXML
    private Button selectPreviousResult;
    @FXML
    private Button selectNextResult;
    @FXML
    private Label resultsLabel;
    @FXML
    private MenuButton searchMenuButton;
    @FXML
    private MenuItem ignoreCaseMenuItem;
    @FXML
    private MenuItem regexMenuItem;
    @FXML
    private Label closeLabel;
    @FXML
    private Label noPayloadLabel;
    @FXML
    private VBox messageGroup;
    @FXML
    private Label emptyLabel;
    @FXML
    private VBox metaHolder;
    private List<Search> results;
    private int currentSearchResult;
    private String currentSearchString = null;
    private MessagePropertiesDTO messageDTO;
    private Task<DetailViewManipulatorHook> lastManipulatorTask;

    private DetailViewController(String connectionId, DetailViewDelegate delegate, boolean isInlineView) {
        super(connectionId);
        this.delegate = delegate;
        this.inlineViewProperty = new SimpleBooleanProperty(isInlineView);
        ExportMessageDispatcher.getInstance().addObserver(this);
        ImportMessageDispatcher.getInstance().addObserver(this);
    }

    private static LoaderResult<DetailViewController> load(String connectionId, DetailViewDelegate delegate, boolean isInlineView) {
        return DetailViewController.load(DetailViewController.class, "detailView.fxml", () -> new DetailViewController(connectionId, delegate, isInlineView));
    }

    public static LoaderResult<DetailViewController> load(MessagePropertiesDTO messageDTO, String connectionId, DetailViewDelegate delegate, boolean isInlineView) {
        LoaderResult<DetailViewController> result = DetailViewController.load(connectionId, delegate, isInlineView);
        result.getController().setMessage(messageDTO);
        resources = result.getResourceBundle();
        if (!isInlineView) {
            result.getController().disableInlineView();
        }
        return result;
    }

    static void showAsDialog(MessagePropertiesDTO messageDTO, String connectionId, DetailViewDelegate delegate) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.DETAIL);
        properties.put((Object)WindowProperty.CONNECTION_ID, connectionId);
        properties.put((Object)WindowProperty.MESSAGE_ID, messageDTO.getMessageId());
        if (WindowHelper.focusWindowIfAlreadyThere(properties)) {
            return;
        }
        LoaderResult<DetailViewController> result = DetailViewController.load(messageDTO, connectionId, delegate, false);
        String title = messageDTO.getMessageType() == MessageType.INCOMING ? resources.getString("detailViewControllerIncomingTitle") : (messageDTO.getMessageType() == MessageType.OUTGOING ? resources.getString("detailViewControllerOutgoingTitle") : resources.getString("detailViewControllerTitle"));
        DetailViewController.showAsDialog(result, title, properties, true, false, null, null);
    }

    private void disableInlineView() {
        this.inlineViewProperty.setValue(Boolean.valueOf(false));
    }

    @FXML
    private void initialize() {
        this.detailViewVBox.getStyleClass().add((Object)SettingsProvider.getInstance().getIconModeCssClass());
        this.searchTextField.textProperty().addListener((observable, oldValue, newValue) -> this.performSearch((String)newValue));
        this.searchTextField.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.ESCAPE == event.getCode()) {
                this.closeSearch();
            } else if (KeyCode.ENTER == event.getCode()) {
                this.selectNextResult();
            }
        });
        this.detailViewVBox.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.isShortcutDown() && KeyCode.F == event.getCode()) {
                this.toggleSearchBar();
            }
        });
        this.detailViewScrollPane.prefWidthProperty().bind((ObservableValue)this.detailViewVBox.widthProperty());
        this.detailViewScrollPane.prefHeightProperty().bind((ObservableValue)this.detailViewVBox.heightProperty());
        DetailContextMenu contextMenu = new DetailContextMenu(this);
        this.metaHolder.setOnContextMenuRequested(event -> {
            if (this.messageDTO != null) {
                contextMenu.setObject(this.messageDTO);
                contextMenu.show((Node)this.metaHolder, event.getScreenX(), event.getScreenY());
            }
        });
        this.detailViewFormatToggleButton.setOnMouseClicked(mouseEvent -> {
            AutoFormatPayload.autoFormatPayload(this.messageDTO.getPayload(), this.detailViewFormatToggleButton.isSelected(), this.getConnectionId(), this.codeArea);
            this.showSearchResult();
        });
        this.initializeManipulation();
    }

    private void initializeManipulation() {
        this.manipulateSelectionButton.getItems().clear();
        this.lastManipulatorTask = null;
        this.manipulateSelectionButton.setText("Manipulate");
        List<Task<DetailViewManipulatorHook>> tasks = PluginManager.getInstance().getTasks(DetailViewManipulatorHook.class);
        tasks.forEach(p -> {
            TaskMenuItem menuItem = new TaskMenuItem(p);
            menuItem.setOnAction(this::onManipulateMessageSelected);
            this.manipulateSelectionButton.getItems().add(menuItem);
        });
        this.manipulateSelectionButton.setOnMouseClicked(this::onManipulateMessageClicked);
        this.manipulateSelectionButton.setVisible(!tasks.isEmpty());
        this.manipulateSelectionButton.setManaged(!tasks.isEmpty());
        this.detailViewRevertManipulationButton.setOnMouseClicked(e -> this.showMessage());
    }

    @FXML
    private void changeIgnoreCase() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clicked on changeIgnoreCase: {}", (Object)this.getConnectionId());
        }
        SettingsProvider.getInstance().getSettings().setUseIgnoreCase(!SettingsProvider.getInstance().getSettings().isUseIgnoreCase());
        SettingsProvider.getInstance().saveSettings(false);
        this.searchMenuButton.getItems().remove((Object)this.ignoreCaseMenuItem);
        if (SettingsProvider.getInstance().getSettings().isUseIgnoreCase()) {
            this.ignoreCaseMenuItem.getStyleClass().add((Object)CHECK_SOLID_CLASS);
        } else {
            this.ignoreCaseMenuItem.getStyleClass().remove((Object)CHECK_SOLID_CLASS);
        }
        this.searchMenuButton.getItems().add(0, (Object)this.ignoreCaseMenuItem);
        this.currentSearchString = null;
        this.currentSearchResult = 0;
        this.showSearchResult();
    }

    @FXML
    private void changeRegex() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clicked on changeRegex: {}", (Object)this.getConnectionId());
        }
        SettingsProvider.getInstance().getSettings().setUseRegexForSearch(!SettingsProvider.getInstance().getSettings().isUseRegexForSearch());
        SettingsProvider.getInstance().saveSettings(false);
        this.searchMenuButton.getItems().remove((Object)this.regexMenuItem);
        if (SettingsProvider.getInstance().getSettings().isUseRegexForSearch()) {
            this.regexMenuItem.getStyleClass().add((Object)CHECK_SOLID_CLASS);
        } else {
            this.regexMenuItem.getStyleClass().remove((Object)CHECK_SOLID_CLASS);
        }
        this.searchMenuButton.getItems().add(1, (Object)this.regexMenuItem);
        this.currentSearchString = null;
        this.currentSearchResult = 0;
        this.showSearchResult();
    }

    void setMessage(MessagePropertiesDTO messageDTO) {
        this.messageDTO = messageDTO;
        if (messageDTO == null) {
            this.showNoMessage();
        } else {
            this.showMessage();
        }
    }

    private void showMessage() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Show message in DetailView: {}", (Object)this.getConnectionId());
        }
        this.detailViewRevertManipulationButton.setDisable(true);
        this.emptyLabel.setVisible(false);
        this.emptyLabel.setManaged(false);
        this.messageGroup.setVisible(true);
        this.messageGroup.setManaged(true);
        this.detailViewTopicLabel.setText(this.messageDTO.getTopic());
        this.detailViewTime.setText(this.messageDTO.getDateTime().toString());
        this.detailViewSaveButton.setDisable(false);
        this.executeOnOpenDetailViewExtensions();
        this.validateMessage(this.messageDTO.getTopic(), this.messageDTO.getPayload());
        this.detailViewRetained.setManaged(this.messageDTO.isRetained());
        this.detailViewRetained.setVisible(this.messageDTO.isRetained());
        this.detailViewQos.setText(this.messageDTO.getQos().toString());
        if (SettingsProvider.getInstance().getSettings().isUseIgnoreCase()) {
            this.ignoreCaseMenuItem.getStyleClass().add((Object)CHECK_SOLID_CLASS);
        }
        if (SettingsProvider.getInstance().getSettings().isUseRegexForSearch()) {
            this.regexMenuItem.getStyleClass().add((Object)CHECK_SOLID_CLASS);
        }
        this.detailViewSaveButton.setOnMouseClicked(this::saveMessage);
        if (this.messageDTO.getPayload().isEmpty()) {
            this.clearPayload();
        } else {
            this.updatePayload(this.messageDTO.getPayload());
        }
    }

    private void executeOnOpenDetailViewExtensions() {
        this.detailViewNodeBox.getChildren().clear();
        PluginManager.getInstance().getExtensions(DetailViewHook.class).forEach(p -> {
            HBox pluginBox = new HBox();
            pluginBox.setAlignment(Pos.CENTER_RIGHT);
            HBox.setHgrow((Node)pluginBox, (Priority)Priority.ALWAYS);
            this.detailViewNodeBox.getChildren().add((Object)pluginBox);
            p.onOpenDetailView(new MessageExtensionDTO(this.messageDTO), pluginBox);
        });
    }

    private void validateMessage(String topic, String payload) {
        this.detailViewValid.setVisible(false);
        this.detailViewValid.setManaged(false);
        this.detailViewInvalid.setVisible(false);
        this.detailViewInvalid.setManaged(false);
        MessageValidatorHook.Validation validation = MessageValidator.validateMessage(topic, payload);
        if (validation != null) {
            this.updateValidatorLabel(this.detailViewValid, validation.isValid(), validation.getTooltip());
            this.updateValidatorLabel(this.detailViewInvalid, !validation.isValid(), validation.getTooltip());
        }
    }

    private void updateValidatorLabel(Label label, boolean isVisible, String tooltip) {
        label.setVisible(isVisible);
        label.setManaged(isVisible);
        label.setTooltip(new Tooltip(tooltip));
    }

    private void onManipulateMessageClicked(MouseEvent event) {
        if (this.lastManipulatorTask != null) {
            this.manipulateMessage(this.lastManipulatorTask);
        }
    }

    private void onManipulateMessageSelected(ActionEvent actionEvent) {
        Task<DetailViewManipulatorHook> manipulatorTask = ((TaskMenuItem)((Object)actionEvent.getSource())).getTask();
        this.manipulateMessage(manipulatorTask);
        this.manipulateSelectionButton.setText(manipulatorTask.getId());
        this.lastManipulatorTask = manipulatorTask;
    }

    private void manipulateMessage(Task<DetailViewManipulatorHook> manipulatorTask) {
        this.detailViewRevertManipulationButton.setDisable(false);
        IndexRange range = this.getSelectionRange();
        byte[] selection = this.codeArea.getText(range).getBytes();
        for (DetailViewManipulatorHook hook : manipulatorTask.getTasks()) {
            selection = hook.manipulate(selection);
        }
        this.codeArea.replaceText(range, new String(selection));
        this.detailViewFormatToggleButton.setSelected(false);
        if (this.messageDTO != null) {
            this.validateMessage(this.messageDTO.getTopic(), this.codeArea.getText());
            AutoFormatPayload.autoFormatPayload(this.codeArea.getText(), true, this.getConnectionId(), this.codeArea);
        }
    }

    private IndexRange getSelectionRange() {
        IndexRange selection = this.codeArea.getSelection();
        if (selection.getLength() == 0) {
            return new IndexRange(0, this.codeArea.getLength());
        }
        return selection;
    }

    private void showNoMessage() {
        this.detailViewSaveButton.setDisable(true);
        this.detailViewFormatToggleButton.setDisable(true);
        this.detailViewSearchButton.setDisable(true);
        this.closeSearch();
        this.emptyLabel.setVisible(true);
        this.emptyLabel.setManaged(true);
        this.messageGroup.setVisible(false);
        this.messageGroup.setManaged(false);
    }

    private void updatePayload(String payload) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updating payload: {}", (Object)this.getConnectionId());
        }
        this.detailViewSearchButton.setDisable(false);
        this.closeSearch();
        this.noPayloadLabel.setManaged(false);
        this.noPayloadLabel.setVisible(false);
        this.detailViewScrollPane.setManaged(true);
        this.detailViewScrollPane.setVisible(true);
        this.detailViewScrollPane.getChildren().add((Object)new VirtualizedScrollPane((Node)this.codeArea));
        this.codeArea.prefWidthProperty().bind((ObservableValue)this.detailViewScrollPane.widthProperty());
        this.codeArea.prefHeightProperty().bind((ObservableValue)this.detailViewScrollPane.heightProperty());
        this.codeArea.setEditable(false);
        Format format = AutoFormatPayload.autoFormatPayload(payload, true, this.getConnectionId(), this.codeArea);
        this.detailViewFormatToggleButton.setSelected(format.isFormatable());
        this.detailViewFormatToggleButton.setDisable(!format.isFormatable());
    }

    private void clearPayload() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clearing payload: {}", (Object)this.getConnectionId());
        }
        this.detailViewSearchButton.setDisable(true);
        this.closeSearch();
        this.noPayloadLabel.setManaged(true);
        this.noPayloadLabel.setVisible(true);
        this.detailViewScrollPane.setManaged(false);
        this.detailViewScrollPane.setVisible(false);
        this.detailViewFormatToggleButton.setSelected(false);
        this.detailViewFormatToggleButton.setDisable(true);
        this.detailViewSearchButton.setDisable(true);
        this.noPayloadLabel.prefWidthProperty().bind((ObservableValue)this.detailViewVBox.widthProperty());
        this.noPayloadLabel.prefHeightProperty().bind((ObservableValue)this.detailViewVBox.heightProperty());
    }

    private void saveMessage(MouseEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clicked on save message: {}", (Object)this.getConnectionId());
        }
        Stage stage = (Stage)this.detailViewVBox.getScene().getWindow();
        MessageUtils.saveMessage(this.getConnectionId(), this.messageDTO, stage);
    }

    private Format autoFormatPayload(String payload, boolean doFormatting) {
        Format foundFormat;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Auto formatting payload: {}", (Object)this.getConnectionId());
        }
        if (doFormatting) {
            ArrayList<DetailViewFormatHook> availableFormats = new ArrayList<DetailViewFormatHook>(PluginManager.getInstance().getExtensions(DetailViewFormatHook.class));
            availableFormats.add((DetailViewFormatHook)((Object)new Plain()));
            foundFormat = availableFormats.stream().filter(Objects::nonNull).filter(format -> {
                try {
                    format.setText(payload);
                    return format.isValid();
                }
                catch (Exception e) {
                    LOGGER.error("Formatting check failed. ", (Throwable)e);
                    return false;
                }
            }).findFirst().orElseThrow(() -> new IllegalArgumentException("Plain format did not match."));
        } else {
            foundFormat = new Plain();
            foundFormat.setText(payload);
        }
        this.codeArea.clear();
        try {
            this.codeArea.replaceText(0, 0, foundFormat.getPrettyString());
            this.codeArea.setStyleSpans(0, foundFormat.getFxSpans());
        }
        catch (Exception e) {
            LOGGER.error("Formatter failed. ", (Throwable)e);
            foundFormat = new Plain();
            foundFormat.setText(payload);
            this.codeArea.replaceText(0, 0, foundFormat.getPrettyString());
            this.codeArea.setStyleSpans(0, foundFormat.getFxSpans());
        }
        return foundFormat;
    }

    private void showSearchResult() {
        this.currentSearchString = (String)this.searchTextField.textProperty().get();
        this.results = new ArrayList<Search>();
        if (!this.currentSearchString.isEmpty()) {
            String codeAreaText = this.codeArea.getText();
            boolean ignoreCase = SettingsProvider.getInstance().getSettings().isUseIgnoreCase();
            boolean regex = SettingsProvider.getInstance().getSettings().isUseRegexForSearch();
            String finalSearchString = regex ? this.currentSearchString : Pattern.quote(this.currentSearchString);
            try {
                Pattern searchPattern = Pattern.compile(finalSearchString, ignoreCase ? 2 : 0);
                Matcher matcher = searchPattern.matcher(codeAreaText);
                while (matcher.find()) {
                    this.results.add(this.results.size(), new Search(matcher.start(), matcher.end()));
                }
            }
            catch (PatternSyntaxException e) {
                LOGGER.debug("Invalid pattern: {}", (Object)e.getMessage());
            }
        }
        if (!this.results.isEmpty()) {
            this.currentSearchResult = 0;
            this.selectPreviousResult.setDisable(false);
            this.selectNextResult.setDisable(false);
        } else {
            this.resultsLabel.setText(null);
            this.selectPreviousResult.setDisable(true);
            this.selectNextResult.setDisable(true);
            this.codeArea.deselect();
        }
        this.updateSearchResult();
    }

    private void performSearch(String newValue) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performing search: {}", (Object)this.getConnectionId());
        }
        if (newValue != null && !newValue.isEmpty() && newValue.equals(this.currentSearchString)) {
            this.selectNextResult();
            return;
        }
        this.showSearchResult();
    }

    private void updateSearchResult() {
        if (this.results == null || this.results.isEmpty()) {
            this.resultsLabel.setText(resources.getString("detailViewControllerNoResults"));
            return;
        }
        this.codeArea.selectRange(this.results.get(this.currentSearchResult).getStartIndex(), this.results.get(this.currentSearchResult).getEndIndex());
        this.resultsLabel.setText(this.currentSearchResult + 1 + " " + resources.getString("detailViewControllerOf") + " " + this.results.size() + " " + resources.getString("detailViewControllerMatches"));
        this.codeArea.scrollXToPixel(0.0);
        this.codeArea.displaceCaret(this.results.get(this.currentSearchResult).getEndIndex());
        this.codeArea.requestFollowCaret();
        this.searchTextField.requestFocus();
    }

    @FXML
    private void selectNextResult() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clicked on next result: {}", (Object)this.getConnectionId());
        }
        if (this.results == null) {
            this.currentSearchResult = 0;
        } else {
            ++this.currentSearchResult;
            if (this.currentSearchResult == this.results.size()) {
                this.currentSearchResult = 0;
            }
        }
        this.updateSearchResult();
    }

    @FXML
    private void selectPreviousResult() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clicked on previous result: {}", (Object)this.getConnectionId());
        }
        if (this.results == null) {
            this.currentSearchResult = 0;
        } else {
            --this.currentSearchResult;
            if (this.currentSearchResult == -1) {
                this.currentSearchResult = this.results.size() - 1;
            }
        }
        this.updateSearchResult();
    }

    public void toggleSearchBar() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Toggling search bar: {}", (Object)this.getConnectionId());
        }
        if (this.detailViewSearchButton.isDisabled()) {
            return;
        }
        if (this.detailViewToolBar.getChildren().contains((Object)this.detailViewSearchHBox)) {
            this.closeSearch();
        } else {
            this.showSearch(true);
        }
    }

    private void showSearch(boolean focus) {
        this.detailViewToolBar.getChildren().remove((Object)this.detailViewSearchButton);
        if (!this.detailViewToolBar.getChildren().contains((Object)this.detailViewSearchHBox)) {
            this.detailViewToolBar.getChildren().add((Object)this.detailViewSearchHBox);
        }
        if (focus) {
            this.searchTextField.requestFocus();
        }
    }

    @FXML
    private void closeSearch() {
        ObservableList barChildren = this.detailViewToolBar.getChildren();
        barChildren.remove((Object)this.detailViewSearchHBox);
        if (!barChildren.contains((Object)this.detailViewSearchButton)) {
            barChildren.add((Object)this.detailViewSearchButton);
        }
        this.resultsLabel.setText("");
        this.searchTextField.setText("");
        this.codeArea.deselect();
        this.detailViewVBox.requestFocus();
    }

    Node getMainNode() {
        return this.detailViewVBox;
    }

    @Override
    public void showDetailsInSeparateWindow(MessagePropertiesDTO messageDTO) {
        DetailViewController.showAsDialog(messageDTO, this.getConnectionId(), this.delegate);
    }

    @Override
    public void setUpToForm(MessagePropertiesDTO messageDTO) {
        this.delegate.setUpToForm(messageDTO);
    }

    @Override
    public BooleanProperty isInlineView() {
        return this.inlineViewProperty;
    }

    @Override
    public void onExportStarted(File file, MessageDTO messageDTO) {
        Platform.runLater(() -> this.detailViewVBox.setDisable(true));
    }

    @Override
    public void onExportSucceeded() {
        Platform.runLater(() -> this.detailViewVBox.setDisable(false));
    }

    @Override
    public void onExportCancelled(File file, MessageDTO messageDTO) {
        Platform.runLater(() -> this.detailViewVBox.setDisable(false));
    }

    @Override
    public void onExportFailed(File file, MessageDTO messageDTO, Throwable exception) {
        Platform.runLater(() -> this.detailViewVBox.setDisable(false));
    }

    @Override
    public void onImportStarted(File file) {
        this.detailViewVBox.setDisable(true);
    }

    @Override
    public void onImportSucceeded(MessageDTO messageDTO) {
        this.detailViewVBox.setDisable(false);
    }

    @Override
    public void onImportCancelled(File file) {
        this.detailViewVBox.setDisable(false);
    }

    @Override
    public void onImportFailed(File file, Throwable exception) {
        this.detailViewVBox.setDisable(false);
    }
}

