/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.correomqtt.gui.controller.BaseConnectionController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.utils.WindowHelper;

public class LoadingViewController
extends BaseConnectionController {
    private final String message;
    @FXML
    private Label progressLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Pane mainPane;

    private LoadingViewController(String connectionId, String message) {
        super(connectionId);
        this.message = message;
    }

    public static LoadingViewController showAsDialog(String connectionId, String message) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.LOADING);
        properties.put((Object)WindowProperty.CONNECTION_ID, connectionId);
        if (WindowHelper.focusWindowIfAlreadyThere(properties)) {
            throw new IllegalStateException("Loading view must be used once per connection only.");
        }
        LoaderResult<LoadingViewController> result = LoadingViewController.load(LoadingViewController.class, "loadingView.fxml", () -> new LoadingViewController(connectionId, message));
        ResourceBundle resources = result.getResourceBundle();
        LoadingViewController.showAsDialog(result, resources.getString("loadingViewControllerWait"), properties, false, true, (EventHandler<WindowEvent>)((EventHandler)Event::consume), null);
        return result.getController();
    }

    public void close() {
        Stage stage = (Stage)this.mainPane.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void initialize() {
        this.progressLabel.setText(this.message);
        this.progressBar.setProgress(-1.0);
    }

    public void setProgress(int progress) {
        this.progressBar.setProgress((double)progress);
    }
}

