/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.io.File;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.correomqtt.business.provider.ConfigProvider;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.utils.HostServicesHolder;
import org.correomqtt.gui.utils.WindowHelper;
import org.correomqtt.plugin.manager.PermissionPlugin;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.manager.PluginSecurityPolicy;
import org.pf4j.Plugin;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;

public class PluginsViewController
extends BaseController {
    @FXML
    private Pane pluginRootPane;
    @FXML
    private TableView<PluginWrapper> pluginsTableView;
    @FXML
    private TableColumn<PluginWrapper, CheckBox> isEnabledColumn;
    @FXML
    private TableColumn<PluginWrapper, String> nameVersionColumn;
    @FXML
    private TableColumn<PluginWrapper, String> descriptionColumn;
    @FXML
    private TableColumn<PluginWrapper, String> providerColumn;
    @FXML
    private TableColumn<PluginWrapper, String> permissionColumn;
    @FXML
    private TableColumn<PluginWrapper, String> fileColumn;
    @FXML
    private Label statusText;
    private boolean isRestartRequired;
    private PluginManager pluginSystem;

    public static void showAsDialog() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.PLUGIN_SETTINGS);
        if (WindowHelper.focusWindowIfAlreadyThere(properties)) {
            return;
        }
        LoaderResult result = PluginsViewController.load(PluginsViewController.class, "pluginsView.fxml");
        ResourceBundle resources = result.getResourceBundle();
        PluginsViewController.showAsDialog(result, resources.getString("pluginsViewControllerTitle"), properties, true, false, null, null);
    }

    @FXML
    public void initialize() {
        this.pluginSystem = PluginManager.getInstance();
        this.setUpTable();
    }

    private void setUpTable() {
        ArrayList allPluginWrappers = new ArrayList(PluginManager.getInstance().getPlugins());
        ObservableList plugins = FXCollections.observableArrayList(allPluginWrappers);
        this.pluginsTableView.setItems(plugins);
        this.isEnabledColumn.setCellValueFactory(this::getIsEnabledCellData);
        this.isEnabledColumn.setSortable(false);
        this.nameVersionColumn.setCellValueFactory(this::getPluginNameAndVersionCellData);
        this.descriptionColumn.setCellValueFactory(cellData -> new SimpleObjectProperty((Object)((PluginWrapper)cellData.getValue()).getDescriptor().getPluginDescription()));
        this.providerColumn.setCellValueFactory(cellData -> new SimpleObjectProperty((Object)((PluginWrapper)cellData.getValue()).getDescriptor().getProvider()));
        this.permissionColumn.setCellValueFactory(this::getPermissionCellData);
        this.fileColumn.setCellValueFactory(cellData -> new SimpleObjectProperty((Object)((PluginWrapper)cellData.getValue()).getPluginPath().toString()));
        this.pluginsTableView.setRowFactory(this::getRowFactory);
    }

    private SimpleObjectProperty<CheckBox> getIsEnabledCellData(TableColumn.CellDataFeatures<PluginWrapper, CheckBox> cellData) {
        CheckBox checkBox = new CheckBox();
        checkBox.selectedProperty().setValue(Boolean.valueOf(!((PluginWrapper)cellData.getValue()).getPluginState().equals((Object)PluginState.DISABLED)));
        checkBox.selectedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (Boolean.TRUE.equals(newValue)) {
                this.pluginSystem.enablePlugin(((PluginWrapper)cellData.getValue()).getPluginId());
            } else {
                this.pluginSystem.disablePlugin(((PluginWrapper)cellData.getValue()).getPluginId());
            }
            this.setStatusRestartRequired();
        });
        return new SimpleObjectProperty((Object)checkBox);
    }

    private SimpleObjectProperty<String> getPluginNameAndVersionCellData(TableColumn.CellDataFeatures<PluginWrapper, String> cellData) {
        String name = ((PluginWrapper)cellData.getValue()).getPluginId();
        String version = ((PluginWrapper)cellData.getValue()).getDescriptor().getVersion();
        return new SimpleObjectProperty((Object)(name + " - " + version));
    }

    private SimpleObjectProperty<String> getPermissionCellData(TableColumn.CellDataFeatures<PluginWrapper, String> cellData) {
        StringBuilder permissions = new StringBuilder();
        Plugin plugin = ((PluginWrapper)cellData.getValue()).getPlugin();
        if (plugin instanceof PermissionPlugin) {
            Permissions pluginPermissions = PluginSecurityPolicy.removeForbiddenPermissions(((PermissionPlugin)plugin).getPermissions());
            Iterator<Permission> it = pluginPermissions.elements().asIterator();
            while (it.hasNext()) {
                Permission p = it.next();
                permissions.append(p.getClass().getSimpleName()).append("(").append(p.getName());
                if (!p.getActions().isBlank()) {
                    permissions.append(", ").append(p.getActions());
                }
                permissions.append("); ");
            }
        }
        return new SimpleObjectProperty((Object)permissions.toString());
    }

    private TableRow<PluginWrapper> getRowFactory(TableView<PluginWrapper> tv) {
        TableRow row = new TableRow();
        row.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2 && !row.isEmpty()) {
                PluginWrapper rowData = (PluginWrapper)row.getItem();
                ClipboardContent content = new ClipboardContent();
                content.putString(rowData.getPluginId());
                Clipboard.getSystemClipboard().setContent((Map)content);
                this.setStatusCopiedToClipboard(rowData.getPluginId());
            }
        });
        return row;
    }

    @FXML
    public void onOpenPluginFolder() {
        HostServicesHolder.getInstance().getHostServices().showDocument(new File(ConfigProvider.getInstance().getPluginRootPath()).toURI().toString());
    }

    private void setStatusRestartRequired() {
        this.isRestartRequired = true;
        this.statusText.setText("To apply your changes, please restart the application.");
        this.statusText.setTextFill((Paint)Color.web((String)"ff0000"));
    }

    private void setStatusCopiedToClipboard(String id) {
        this.statusText.setText("Plugin ID copied to clipboard: " + id);
        this.statusText.setTextFill((Paint)Color.web((String)"000000"));
        PauseTransition wait = new PauseTransition(Duration.seconds((double)2.0));
        wait.setOnFinished(e -> {
            if (this.isRestartRequired) {
                this.setStatusRestartRequired();
            } else {
                this.statusText.setText("");
            }
        });
        wait.play();
    }
}

