/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import org.correomqtt.business.keyring.KeyringFactory;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.model.ThemeDTO;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.cell.GenericCell;
import org.correomqtt.gui.controller.BaseController;
import org.correomqtt.gui.controller.LoaderResult;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.keyring.KeyringHandler;
import org.correomqtt.gui.model.KeyringModel;
import org.correomqtt.gui.model.LanguageModel;
import org.correomqtt.gui.model.WindowProperty;
import org.correomqtt.gui.model.WindowType;
import org.correomqtt.gui.theme.ThemeProvider;
import org.correomqtt.gui.theme.light.LightThemeProvider;
import org.correomqtt.plugin.manager.PluginManager;
import org.correomqtt.plugin.spi.ThemeProviderHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsViewController
extends BaseController {
    @FXML
    private AnchorPane settingsPane;
    @FXML
    private VBox settingsVBox;
    @FXML
    private ComboBox<ThemeProvider> themeComboBox;
    @FXML
    private ComboBox<LanguageModel> languageComboBox;
    @FXML
    private ComboBox<KeyringModel> keyringBackendComboBox;
    @FXML
    private CheckBox searchUpdatesCheckbox;
    @FXML
    private Label keyringDescriptionLabel;
    private static ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
    private SettingsDTO settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsViewController.class);

    public static LoaderResult<SettingsViewController> load() {
        return SettingsViewController.load(SettingsViewController.class, "settingsView.fxml");
    }

    public static LoaderResult<SettingsViewController> showAsDialog() {
        LoaderResult<SettingsViewController> result = SettingsViewController.load();
        resources = result.getResourceBundle();
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put((Object)WindowProperty.WINDOW_TYPE, (Object)WindowType.SETTINGS);
        SettingsViewController.showAsDialog(result, resources.getString("settingsViewControllerTitle"), properties, false, false, null, (EventHandler<KeyEvent>)((EventHandler)event -> ((SettingsViewController)result.getController()).keyHandling((KeyEvent)event)));
        return result;
    }

    @FXML
    public void initialize() {
        this.settings = SettingsProvider.getInstance().getSettings();
        this.setupGUI();
        this.themeComboBox.setOnAction(actionEvent -> this.onThemeChanged());
        this.languageComboBox.setOnAction(actionEvent -> this.onLanguageChanged());
    }

    private void onLanguageChanged() {
    }

    @FXML
    public void onCancelClicked() {
        LOGGER.debug("Cancel in settings clicked");
        this.closeDialog();
    }

    @FXML
    public void onSaveClicked() {
        LOGGER.debug("Save in settings clicked");
        this.saveSettings();
        this.closeDialog();
    }

    @FXML
    public void onWipeKeyringClicked() {
        boolean confirmed = AlertHelper.confirm(resources.getString("wipeCurrentKeyringTitle"), resources.getString("wipeCurrentKeyringHeader"), resources.getString("wipeCurrentKeyringContent"), resources.getString("commonCancelButton"), resources.getString("wipeOutYesButton"));
        if (confirmed) {
            KeyringHandler.getInstance().retryWithMasterPassword(masterPassword -> SettingsProvider.getInstance().wipeSecretData(masterPassword), resources.getString("onPasswordWipeFailedTitle"), resources.getString("onPasswordWipeFailedHeader"), resources.getString("onPasswordWipeFailedContent"), resources.getString("onPasswordWipeFailedGiveUp"), resources.getString("onPasswordWipeFailedTryAgain"));
        }
    }

    @FXML
    public void onThemeChanged() {
        LOGGER.debug("Theme changed in settings");
    }

    @FXML
    public void onKeyringBackendChanged() {
        LOGGER.debug("Keyring backend changed in settings");
    }

    private void setupGUI() {
        this.searchUpdatesCheckbox.setSelected(this.settings.isSearchUpdates());
        ArrayList<ThemeProviderHook> themes = new ArrayList<ThemeProviderHook>(PluginManager.getInstance().getExtensions(ThemeProviderHook.class));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(themes.stream().map(ThemeProvider::getName).collect(Collectors.joining(",")));
        }
        this.themeComboBox.setOnAction(null);
        this.themeComboBox.setItems(FXCollections.observableArrayList(themes));
        this.themeComboBox.setCellFactory(GenericCell::new);
        this.themeComboBox.setConverter((StringConverter)new StringConverter<ThemeProvider>(){

            public String toString(ThemeProvider object) {
                if (object == null) {
                    return null;
                }
                return object.getName();
            }

            public ThemeProvider fromString(String string) {
                return null;
            }
        });
        this.themeComboBox.getSelectionModel().select((Object)themes.stream().filter(t -> t.getName().equals(SettingsProvider.getInstance().getThemeSettings().getActiveTheme().getName())).findFirst().orElse(new LightThemeProvider()));
        List keyringModels = KeyringFactory.getSupportedKeyrings().stream().map(KeyringModel::new).collect(Collectors.toList());
        this.keyringBackendComboBox.setOnAction(event -> this.updateKeyringDescription((KeyringModel)this.keyringBackendComboBox.getSelectionModel().getSelectedItem()));
        this.keyringBackendComboBox.setItems(FXCollections.observableArrayList(keyringModels));
        this.keyringBackendComboBox.setCellFactory(GenericCell::new);
        this.keyringBackendComboBox.setConverter((StringConverter)new StringConverter<KeyringModel>(){

            public String toString(KeyringModel object) {
                if (object == null) {
                    return null;
                }
                return object.getLabelTranslationKey();
            }

            public KeyringModel fromString(String string) {
                return null;
            }
        });
        KeyringModel selectedKeyring = keyringModels.stream().filter(t -> t.getKeyring().getIdentifier().equals(SettingsProvider.getInstance().getSettings().getKeyringIdentifier())).findFirst().orElse(null);
        this.keyringBackendComboBox.getSelectionModel().select((Object)selectedKeyring);
        if (selectedKeyring != null) {
            this.updateKeyringDescription(selectedKeyring);
        }
        this.languageComboBox.setCellFactory(GenericCell::new);
        this.languageComboBox.setConverter((StringConverter)new StringConverter<LanguageModel>(){

            public String toString(LanguageModel language) {
                return language.getLabelTranslationKey();
            }

            public LanguageModel fromString(String string) {
                return null;
            }
        });
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (Locale locale : Locale.getAvailableLocales()) {
            if (SettingsViewController.class.getResource("/org/correomqtt/i18n_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties") == null) continue;
            availableLocales.add(locale);
        }
        this.languageComboBox.setItems(FXCollections.observableArrayList((Collection)availableLocales.stream().filter(SettingsViewController.distinctByKey(l -> l.getLanguage() + "_" + l.getCountry())).map(LanguageModel::new).collect(Collectors.toList())));
        this.languageComboBox.getSelectionModel().select((Object)new LanguageModel(this.settings.getSavedLocale()));
        this.settingsPane.setMinHeight(500.0);
        this.settingsPane.setMaxHeight(500.0);
    }

    private void updateKeyringDescription(KeyringModel selectedKeyring) {
        this.keyringDescriptionLabel.setText(resources.getString("settingsViewKeyringBackendExplanationLabel") + "\n\n" + selectedKeyring.getLabelTranslationKey() + ":\n" + selectedKeyring.getKeyring().getDescription());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private void saveSettings() {
        LOGGER.debug("Saving settings");
        String newKeyringIdentifier = ((KeyringModel)this.keyringBackendComboBox.getSelectionModel().getSelectedItem()).getKeyring().getIdentifier();
        String oldKeyringIdentifier = this.settings.getKeyringIdentifier();
        if (!newKeyringIdentifier.equals(oldKeyringIdentifier)) {
            this.settings.setKeyringIdentifier(newKeyringIdentifier);
            KeyringHandler.getInstance().migrate(newKeyringIdentifier);
        }
        this.settings.setSearchUpdates(this.searchUpdatesCheckbox.isSelected());
        ThemeProvider selectedTheme = (ThemeProvider)this.themeComboBox.getSelectionModel().getSelectedItem();
        this.settings.setSavedLocale(((LanguageModel)this.languageComboBox.getSelectionModel().getSelectedItem()).getLocale());
        SettingsProvider.getInstance().getThemeSettings().setActiveTheme(new ThemeDTO(selectedTheme.getName(), selectedTheme.getIconMode()));
        SettingsProvider.getInstance().saveSettings(true);
    }

    private void closeDialog() {
        Stage stage = (Stage)this.themeComboBox.getScene().getWindow();
        stage.close();
    }

    private void keyHandling(KeyEvent event) {
        if (KeyCode.ESCAPE == event.getCode()) {
            this.closeDialog();
        }
    }
}

