/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.keyring;

import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.correomqtt.business.keyring.Keyring;
import org.correomqtt.business.keyring.KeyringFactory;
import org.correomqtt.business.model.ConnectionConfigDTO;
import org.correomqtt.business.model.SettingsDTO;
import org.correomqtt.business.provider.EncryptionRecoverableException;
import org.correomqtt.business.provider.SecretStoreProvider;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.gui.helper.AlertHelper;
import org.correomqtt.gui.keyring.ConsumerWithRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyringHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyringHandler.class);
    private static KeyringHandler instance = null;
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
    private String masterPassword;
    private static final String KEYRING_LABEL = "CorreoMQTT_MasterPassword";
    private Keyring keyring;

    public static synchronized KeyringHandler getInstance() {
        if (instance == null) {
            instance = new KeyringHandler();
            return instance;
        }
        return instance;
    }

    private KeyringHandler() {
    }

    public void migrate(String newKeyringIdentifier) {
        this.retryWithMasterPassword(pw -> SecretStoreProvider.getInstance().ensurePasswordsAreDecrypted(pw), this.resources.getString("onPasswordSaveFailedTitle"), this.resources.getString("onPasswordSaveFailedHeader"), this.resources.getString("onPasswordSaveFailedContent"), this.resources.getString("onPasswordSaveFailedGiveUp"), this.resources.getString("onPasswordSaveFailedTryAgain"));
        this.keyring = KeyringFactory.createKeyringByIdentifier(newKeyringIdentifier);
        if (this.keyring == null) {
            AlertHelper.warn(this.resources.getString("couldNotCreateNewKeyringBackendTitle"), this.resources.getString("couldNotCreateNewKeyringBackendContent"));
        } else {
            this.masterPassword = null;
            this.getMasterPassword();
            if (!this.keyring.requiresUserinput()) {
                this.keyring.setPassword(KEYRING_LABEL, this.masterPassword);
            }
            List<ConnectionConfigDTO> connections = SettingsProvider.getInstance().getConnectionConfigs();
            this.retryWithMasterPassword(pw -> SettingsProvider.getInstance().saveConnections(connections, pw), this.resources.getString("onPasswordSaveFailedTitle"), this.resources.getString("onPasswordSaveFailedHeader"), this.resources.getString("onPasswordSaveFailedContent"), this.resources.getString("onPasswordSaveFailedGiveUp"), this.resources.getString("onPasswordSaveFailedTryAgain"));
        }
    }

    public String getMasterPassword() {
        if (this.masterPassword != null) {
            return this.masterPassword;
        }
        if (this.keyring != null) {
            if (this.keyring.requiresUserinput()) {
                this.masterPassword = AlertHelper.passwordInput(this.resources.getString("onPasswordRequiredTitle"), this.resources.getString("onPasswordRequiredHeader"), this.resources.getString("onPasswordRequiredContent"));
            } else {
                this.masterPassword = this.keyring.getPassword(KEYRING_LABEL);
                if (this.masterPassword == null || this.masterPassword.isEmpty()) {
                    this.keyring.setPassword(KEYRING_LABEL, UUID.randomUUID().toString());
                    this.masterPassword = this.keyring.getPassword(KEYRING_LABEL);
                }
            }
        }
        return this.masterPassword;
    }

    public void retryWithMasterPassword(ConsumerWithRetry consumer, String title, String header, String content, String noButton, String yesButton) {
        boolean failed = false;
        do {
            boolean retry = false;
            if (failed) {
                this.masterPassword = null;
                retry = AlertHelper.confirm(title, header, content, noButton, yesButton);
            }
            if (!failed || retry) {
                failed = false;
                try {
                    consumer.apply(this.getMasterPassword());
                }
                catch (EncryptionRecoverableException e) {
                    LOGGER.error("Error de/encrypt passwords. ", (Throwable)e);
                    failed = true;
                }
                continue;
            }
            failed = false;
            this.wipe();
        } while (failed);
    }

    public void init() {
        SettingsDTO settings = SettingsProvider.getInstance().getSettings();
        String oldKeyringIdentifier = settings.getKeyringIdentifier();
        this.keyring = null;
        if (oldKeyringIdentifier != null) {
            this.keyring = KeyringFactory.createKeyringByIdentifier(oldKeyringIdentifier);
        }
        if (this.keyring == null) {
            this.keyring = KeyringFactory.create();
        }
        String newKeyringIdentifier = this.keyring.getIdentifier();
        ComparableVersion createdVersion = new ComparableVersion(settings.getConfigCreatedWithCorreoVersion().replaceAll("[^0-9\\.]", ""));
        ComparableVersion keyringSupportVersion = new ComparableVersion("0.13.0");
        if (oldKeyringIdentifier == null && keyringSupportVersion.compareTo(createdVersion) > 0) {
            AlertHelper.info(this.resources.getString("newKeyringTitle"), this.resources.getString("newKeyringContent") + newKeyringIdentifier, true);
        } else if (!newKeyringIdentifier.equals(oldKeyringIdentifier)) {
            AlertHelper.warn(this.resources.getString("changedKeyringTitle"), this.resources.getString("changedKeyringContent") + oldKeyringIdentifier + " -> " + newKeyringIdentifier, true);
        }
        if (!newKeyringIdentifier.equals(oldKeyringIdentifier)) {
            settings.setKeyringIdentifier(newKeyringIdentifier);
        }
    }

    public void wipe() {
        this.masterPassword = null;
        SecretStoreProvider.getInstance().wipe();
    }
}

