/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.gui.model;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.correomqtt.gui.model.GenericCellModel;

public class LanguageModel
implements GenericCellModel {
    private Locale locale;

    @Override
    public String getLabelTranslationKey() {
        return StringUtils.capitalize((String)this.locale.getDisplayLanguage(this.locale));
    }

    public boolean equals(Object language) {
        if (!(language instanceof LanguageModel)) {
            return false;
        }
        return ((LanguageModel)language).getLocale().equals(this.locale);
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public static LanguageModelBuilder builder() {
        return new LanguageModelBuilder();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public LanguageModel(Locale locale) {
        this.locale = locale;
    }

    public static class LanguageModelBuilder {
        private Locale locale;

        LanguageModelBuilder() {
        }

        public LanguageModelBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public LanguageModel build() {
            return new LanguageModel(this.locale);
        }

        public String toString() {
            return "LanguageModel.LanguageModelBuilder(locale=" + this.locale + ")";
        }
    }
}

