/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.correomqtt.business.dispatcher.PreloadingDispatcher;
import org.correomqtt.business.dispatcher.StartupDispatcher;
import org.correomqtt.business.provider.BaseUserFileProvider;
import org.correomqtt.business.provider.SettingsProvider;
import org.correomqtt.business.utils.VendorConstants;
import org.correomqtt.business.utils.VersionUtils;
import org.correomqtt.plugin.manager.PluginManager;
import org.pf4j.update.DefaultUpdateRepository;
import org.pf4j.update.PluginInfo;
import org.pf4j.update.UpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginSystem.class);
    private ResourceBundle resources = ResourceBundle.getBundle("org.correomqtt.i18n", SettingsProvider.getInstance().getSettings().getCurrentLocale());
    private String pluginsDisabledPath = new BaseUserFileProvider().getTargetDirectoryPath() + File.separator + "plugins.disabled.";

    public void start() throws IOException {
        this.start(true);
    }

    public void start(boolean retry) throws IOException {
        String pluginDir = new BaseUserFileProvider().getTargetDirectoryPath() + File.separator + "plugins";
        String brokenFile = pluginDir + File.separator + "broken";
        if (new File(brokenFile).exists()) {
            this.disableAllPluginsDueToErrors();
        }
        PluginManager pluginManager = PluginManager.getInstance();
        try {
            PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderLoadPlugins"));
            pluginManager.loadPlugins();
            PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderUpdatePlugins"));
            this.updateSystem(pluginManager);
            PreloadingDispatcher.getInstance().onProgress(this.resources.getString("preloaderStartPlugins"));
            pluginManager.startPlugins();
        }
        catch (UnknownHostException ue) {
            LOGGER.info("No internet connection for updating plugins");
        }
        catch (Exception | NoClassDefFoundError e) {
            LOGGER.error("Error or Exception during loading plugins ", e);
            if (new BaseUserFileProvider().isWindows()) {
                FileUtils.writeStringToFile((File)new File(brokenFile), (String)e.getMessage(), (Charset)StandardCharsets.UTF_8);
                StartupDispatcher.getInstance().onPluginLoadFailed();
            }
            if (retry) {
                FileUtils.writeStringToFile((File)new File(brokenFile), (String)e.getMessage(), (Charset)StandardCharsets.UTF_8);
                this.disableAllPluginsDueToErrors();
                PluginManager.resetInstance();
                this.start(false);
            }
            StartupDispatcher.getInstance().onPluginLoadFailed();
        }
    }

    private void disableAllPluginsDueToErrors() throws IOException {
        String disabledPath = this.pluginsDisabledPath + new SimpleDateFormat("yyyy-dd-MM_HH-mm-ss").format(new Date());
        FileUtils.moveDirectory((File)new File(new BaseUserFileProvider().getTargetDirectoryPath() + File.separator + "plugins"), (File)new File(disabledPath));
        StartupDispatcher.getInstance().onPluginUpdateFailed(disabledPath);
    }

    private void updateSystem(PluginManager pluginManager) throws IOException {
        LOGGER.info("Start Plugin Update from {}", (Object)VendorConstants.PLUGIN_REPO_URL);
        URL versionRepo = new URL(VendorConstants.PLUGIN_REPO_URL);
        HttpURLConnection connection = (HttpURLConnection)versionRepo.openConnection();
        if (connection.getResponseCode() == 200) {
            List<DefaultUpdateRepository> repos = Collections.singletonList(new DefaultUpdateRepository("bundled", versionRepo, "plugins-" + VersionUtils.getVersion().trim() + ".json"));
            UpdateManager updateManager = new UpdateManager((org.pf4j.PluginManager)pluginManager, repos);
            this.updateExisitingPlugins(updateManager, pluginManager);
            this.installNewPlugins(updateManager);
        } else {
            LOGGER.info("No default plugins available.");
        }
    }

    private void installNewPlugins(UpdateManager updateManager) {
        if (updateManager.hasAvailablePlugins()) {
            List availablePlugins = updateManager.getAvailablePlugins();
            LOGGER.info("Found {} available plugins", (Object)availablePlugins.size());
            for (PluginInfo plugin : availablePlugins) {
                PreloadingDispatcher.getInstance().onProgress(this.resources.getString("pluginUpdateManagerInstalling") + " " + plugin.id);
                LOGGER.info("Found available plugin '{}'", (Object)plugin.id);
                PluginInfo.PluginRelease lastRelease = updateManager.getLastPluginRelease(plugin.id);
                String lastVersion = lastRelease.version;
                LOGGER.info("Install plugin '{}' with version {}", (Object)plugin.id, (Object)lastVersion);
                try {
                    boolean installed = updateManager.installPlugin(plugin.id, lastVersion);
                    if (installed) {
                        LOGGER.info("Installed plugin '{}'", (Object)plugin.id);
                        PreloadingDispatcher.getInstance().onProgress(this.resources.getString("pluginUpdateManagerInstalled") + " " + plugin.id);
                        continue;
                    }
                    LOGGER.error("Cannot install plugin '{}'", (Object)plugin.id);
                }
                catch (Exception e) {
                    LOGGER.error("Plugin installation failed: '{}'", (Object)plugin.id, (Object)e);
                }
            }
        } else {
            LOGGER.info("No available plugins found");
        }
    }

    private void updateExisitingPlugins(UpdateManager updateManager, PluginManager pluginManager) {
        if (updateManager.hasUpdates()) {
            List updates = updateManager.getUpdates();
            LOGGER.info("Found {} plugin updates", (Object)updates.size());
            for (PluginInfo plugin : updates) {
                PreloadingDispatcher.getInstance().onProgress(this.resources.getString("pluginUpdateManagerUpdating") + " " + plugin.id);
                LOGGER.info("Found update for plugin '{}'", (Object)plugin.id);
                PluginInfo.PluginRelease lastRelease = updateManager.getLastPluginRelease(plugin.id);
                String lastVersion = lastRelease.version;
                String installedVersion = pluginManager.getPlugin(plugin.id).getDescriptor().getVersion();
                LOGGER.info("Update plugin '{}' from version {} to version {}", new Object[]{plugin.id, installedVersion, lastVersion});
                try {
                    if (updateManager.updatePlugin(plugin.id, lastVersion)) {
                        LOGGER.info("Updated plugin '{}'", (Object)plugin.id);
                        PreloadingDispatcher.getInstance().onProgress(this.resources.getString("pluginUpdateManagerUpdated") + " " + plugin.id);
                        continue;
                    }
                    LOGGER.warn("Cannot update plugin '{}'", (Object)plugin.id);
                }
                catch (Exception e) {
                    LOGGER.error("Plugin update failed: '{}'", (Object)plugin.id, (Object)e);
                }
            }
        } else {
            LOGGER.info("No updates found");
        }
    }
}

