/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin.manager;

import java.io.File;
import java.io.FilePermission;
import java.security.Policy;
import org.correomqtt.business.provider.ConfigProvider;
import org.correomqtt.plugin.manager.PermissionPlugin;
import org.correomqtt.plugin.manager.PluginSecurityPolicy;
import org.pf4j.DefaultPluginFactory;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class PermissionPluginFactory
extends DefaultPluginFactory {
    private PluginSecurityPolicy pluginSecurityPolicy = (PluginSecurityPolicy)Policy.getPolicy();

    PermissionPluginFactory() {
    }

    public Plugin create(PluginWrapper pluginWrapper) {
        Plugin plugin = super.create(pluginWrapper);
        if (plugin instanceof PermissionPlugin) {
            this.addPluginPermissions(pluginWrapper.getPluginId(), (PermissionPlugin)plugin);
        }
        return plugin;
    }

    private void addPluginPermissions(String pluginId, PermissionPlugin permissionPlugin) {
        String pluginConfigFolder = ConfigProvider.getInstance().getPluginConfigPath(pluginId);
        this.pluginSecurityPolicy.addPluginPermission(pluginId, this.getPluginConfigFolderPermission(pluginConfigFolder));
        permissionPlugin.setPluginConfigFolder(pluginConfigFolder);
        this.pluginSecurityPolicy.addPluginPermissions(pluginId, permissionPlugin.getPermissions());
    }

    private FilePermission getPluginConfigFolderPermission(String pluginConfigFolder) {
        return new FilePermission(pluginConfigFolder + File.separator + "-", "read, write");
    }
}

