/*
 * Decompiled with CFR 0.152.
 */
package org.correomqtt.plugin.model;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import org.correomqtt.business.model.MessageType;
import org.correomqtt.business.model.PublishStatus;
import org.correomqtt.business.model.Qos;
import org.correomqtt.gui.model.MessagePropertiesDTO;

public class MessageExtensionDTO {
    private String topic;
    private String payload;
    private boolean isRetained;
    private Qos qos;
    private LocalDateTime dateTime;
    private String messageId;
    private MessageType messageType;
    private PublishStatus publishStatus;
    private HashMap<String, Object> customFields;

    public MessageExtensionDTO(MessagePropertiesDTO messagePropertiesDTO) {
        this.topic = messagePropertiesDTO.getTopic();
        this.payload = messagePropertiesDTO.getPayload();
        this.isRetained = messagePropertiesDTO.isRetained();
        this.qos = messagePropertiesDTO.getQos();
        this.dateTime = messagePropertiesDTO.getDateTime();
        this.messageId = messagePropertiesDTO.getMessageId();
        this.messageType = messagePropertiesDTO.getMessageType();
        this.publishStatus = messagePropertiesDTO.getPublishStatus();
        this.customFields = new HashMap<String, Object>((Map<String, Object>)messagePropertiesDTO.getExtraProperties());
    }

    public MessagePropertiesDTO merge(MessagePropertiesDTO messageDTO) {
        messageDTO.getTopicProperty().setValue(this.topic);
        messageDTO.getPayloadProperty().setValue(this.payload);
        messageDTO.getIsRetainedProperty().setValue(Boolean.valueOf(this.isRetained));
        messageDTO.getQosProperty().setValue((Object)this.qos);
        messageDTO.getDateTimeProperty().setValue((Object)this.dateTime);
        messageDTO.getMessageIdProperty().setValue(this.messageId);
        messageDTO.getMessageTypeProperty().setValue((Object)this.messageType);
        messageDTO.getPublishStatusProperty().setValue((Object)this.publishStatus);
        messageDTO.getExtraProperties().setValue(FXCollections.observableMap(this.customFields));
        return messageDTO;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setRetained(boolean isRetained) {
        this.isRetained = isRetained;
    }

    public void setQos(Qos qos) {
        this.qos = qos;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setPublishStatus(PublishStatus publishStatus) {
        this.publishStatus = publishStatus;
    }

    public void setCustomFields(HashMap<String, Object> customFields) {
        this.customFields = customFields;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getPayload() {
        return this.payload;
    }

    public boolean isRetained() {
        return this.isRetained;
    }

    public Qos getQos() {
        return this.qos;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public PublishStatus getPublishStatus() {
        return this.publishStatus;
    }

    public HashMap<String, Object> getCustomFields() {
        return this.customFields;
    }
}

