/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.android.runtime;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class TypedDefinitionAdapterFactory<T>
implements TypeAdapterFactory {
    private Class<T> unionClass;
    private Resolver<T> resolver;

    public TypedDefinitionAdapterFactory(Class<T> unionClass, Resolver<T> resolver) {
        this.unionClass = unionClass;
        this.resolver = resolver;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (type.getType().equals(this.unionClass)) {
            return new TypedDefinitionAdapter(gson);
        }
        return null;
    }

    private class TypedDefinitionAdapter<T>
    extends TypeAdapter<T> {
        private Gson gson;

        public TypedDefinitionAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (!TypedDefinitionAdapterFactory.this.unionClass.equals(value.getClass())) {
                TypeToken actualType = TypeToken.get(value.getClass());
                this.gson.getDelegateAdapter((TypeAdapterFactory)TypedDefinitionAdapterFactory.this, actualType).write(out, value);
            }
        }

        public T read(JsonReader reader) throws IOException {
            JsonElement element = new JsonParser().parse(reader);
            JsonObject obj = element.getAsJsonObject();
            JsonElement typeNameElement = obj.get("typeName");
            if (typeNameElement == null) {
                throw new IOException("'typeName' expected but not found when reading '" + TypedDefinitionAdapterFactory.this.unionClass.getName() + "'" + " at path " + reader.getPath());
            }
            String typeName = typeNameElement.getAsString();
            Class clazz = TypedDefinitionAdapterFactory.this.resolver.resolve(typeName);
            return (T)this.gson.getAdapter(clazz).fromJsonTree(element);
        }
    }

    public static interface Resolver<T> {
        public Class<? extends T> resolve(String var1);
    }
}

