/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.android.runtime;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UnionAdapterFactory<T>
implements TypeAdapterFactory {
    private Class<T> unionClass;
    private Resolver<T> resolver;

    public UnionAdapterFactory(Class<T> unionClass, Resolver<T> resolver) {
        this.unionClass = unionClass;
        this.resolver = resolver;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (type.getType().equals(this.unionClass)) {
            return new UnionAdapter(gson);
        }
        throw new IllegalArgumentException("ExampleUnion.JsonAdapter may only be used with " + this.unionClass.getName() + ", but was used " + "with: " + type.getRawType().getClass().getName());
    }

    private class UnionAdapter<T>
    extends TypeAdapter<T> {
        private Gson gson;

        public UnionAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, T value) throws IOException {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be applied to concrete " + "classes, only interfaces, but was applied to " + value.getClass().getName());
        }

        public T read(JsonReader reader) throws IOException {
            JsonElement element = new JsonParser().parse(reader);
            Set entries = element.getAsJsonObject().entrySet();
            if (entries.size() != 1) {
                StringBuilder keys = new StringBuilder();
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    keys.append("'").append((String)((Map.Entry)iter.next()).getKey()).append("'");
                    if (!iter.hasNext()) continue;
                    keys.append(", ");
                }
                throw new IOException("JSON object for '" + UnionAdapterFactory.this.unionClass.getName() + "' union must contain exactly one " + "'memberKey' field, but contains: " + keys.toString() + " at path " + reader.getPath());
            }
            Map.Entry member = (Map.Entry)entries.iterator().next();
            Class clazz = UnionAdapterFactory.this.resolver.resolve((String)member.getKey());
            return (T)this.gson.getAdapter(clazz).fromJsonTree(element);
        }
    }

    public static interface Resolver<T> {
        public Class<? extends T> resolve(String var1);
    }
}

