/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.android.runtime;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class TypedDefinitionAdapterFactory<T>
implements TypeAdapterFactory {
    private Class<T> unionClass;
    private Resolver<T> resolver;

    public TypedDefinitionAdapterFactory(Class<T> clazz, Resolver<T> resolver) {
        this.unionClass = clazz;
        this.resolver = resolver;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (typeToken.getType().equals(this.unionClass)) {
            return new TypedDefinitionAdapter(gson);
        }
        return null;
    }

    private class TypedDefinitionAdapter<T>
    extends TypeAdapter<T> {
        private Gson gson;

        public TypedDefinitionAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter jsonWriter, T t) throws IOException {
            if (!TypedDefinitionAdapterFactory.this.unionClass.equals(t.getClass())) {
                TypeToken typeToken = TypeToken.get(t.getClass());
                this.gson.getDelegateAdapter((TypeAdapterFactory)TypedDefinitionAdapterFactory.this, typeToken).write(jsonWriter, t);
            }
        }

        public T read(JsonReader jsonReader) throws IOException {
            JsonElement jsonElement = new JsonParser().parse(jsonReader);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement jsonElement2 = jsonObject.get("typeName");
            if (jsonElement2 == null) {
                throw new IOException("'typeName' expected but not found when reading '" + TypedDefinitionAdapterFactory.this.unionClass.getName() + "'" + " at path " + jsonReader.getPath());
            }
            String string = jsonElement2.getAsString();
            Class clazz = TypedDefinitionAdapterFactory.this.resolver.resolve(string);
            return (T)this.gson.getAdapter(clazz).fromJsonTree(jsonElement);
        }
    }

    public static interface Resolver<T> {
        public Class<? extends T> resolve(String var1);
    }
}

