/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.android.runtime;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UnionAdapterFactory<T>
implements TypeAdapterFactory {
    private Class<T> unionClass;
    private Resolver<T> resolver;

    public UnionAdapterFactory(Class<T> clazz, Resolver<T> resolver) {
        this.unionClass = clazz;
        this.resolver = resolver;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (this.unionClass.equals(typeToken.getType())) {
            return new UnionAdapter(gson);
        }
        return null;
    }

    private class UnionAdapter<T>
    extends TypeAdapter<T> {
        private Gson gson;

        public UnionAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter jsonWriter, T t) throws IOException {
            if (!UnionAdapterFactory.this.unionClass.equals(t.getClass())) {
                TypeToken typeToken = TypeToken.get(t.getClass());
                this.gson.getDelegateAdapter((TypeAdapterFactory)UnionAdapterFactory.this, typeToken).write(jsonWriter, t);
            }
        }

        public T read(JsonReader jsonReader) throws IOException {
            JsonElement jsonElement = new JsonParser().parse(jsonReader);
            Set set = jsonElement.getAsJsonObject().entrySet();
            if (set.size() != 1) {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append("'").append((String)((Map.Entry)iterator.next()).getKey()).append("'");
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                throw new IOException("JSON object for '" + UnionAdapterFactory.this.unionClass.getName() + "' union must contain exactly one " + "'memberKey' field but contains " + (stringBuilder.length() > 0 ? stringBuilder.toString() : "no fields") + " at path " + jsonReader.getPath());
            }
            Map.Entry entry = (Map.Entry)set.iterator().next();
            Class clazz = UnionAdapterFactory.this.resolver.resolve((String)entry.getKey());
            return (T)this.gson.getAdapter(clazz).fromJsonTree(jsonElement);
        }
    }

    public static interface Resolver<T> {
        public Class<? extends T> resolve(String var1);
    }
}

