/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.EnumTemplateSpec;
import com.linkedin.pegasus.generator.spec.FixedTemplateSpec;
import com.linkedin.pegasus.generator.spec.ModifierSpec;
import com.linkedin.pegasus.generator.spec.PrimitiveTemplateSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.TyperefTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.coursera.courier.api.CourierMapTemplateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourierTemplateSpecGenerator {
    private static final Logger _log = LoggerFactory.getLogger(CourierTemplateSpecGenerator.class);
    private static final String CLASS_PROPERTY = "class";
    private final String courierPackageName = "org.coursera.courier.data";
    private static final String COERCER_CLASS_PROPERTY = "coercerClass";
    private static final String ARRAY_SUFFIX = "Array";
    private static final String MAP_SUFFIX = "Map";
    private static final String[] SPECIAL_SUFFIXES = new String[]{"Array", "Map"};
    private static final String _templatePackageName = DataTemplate.class.getPackage().getName();
    private final Collection<ClassTemplateSpec> _classTemplateSpecs = new HashSet<ClassTemplateSpec>();
    private final Map<ClassTemplateSpec, DataSchemaLocation> _classToDataSchemaLocationMap = new HashMap<ClassTemplateSpec, DataSchemaLocation>();
    private final Map<String, DataSchema> _classNameToSchemaMap = new HashMap<String, DataSchema>(100);
    private final IdentityHashMap<DataSchema, ClassTemplateSpec> _schemaToClassMap = new IdentityHashMap(100);
    private final Deque<DataSchemaLocation> _locationStack = new ArrayDeque<DataSchemaLocation>();
    private final Map<DataSchema, CustomInfoSpec> _immediateCustomMap = new IdentityHashMap<DataSchema, CustomInfoSpec>();
    private final DataSchemaResolver _schemaResolver;
    private final SchemaParser _schemaParser;
    private final String _dataNamespace;
    private final String _customTypeLanguage;

    public static String classNameForNamedSchema(NamedDataSchema namedDataSchema) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = namedDataSchema.getNamespace();
        if (!string.isEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append('.');
        }
        stringBuilder.append(namedDataSchema.getName());
        return stringBuilder.toString();
    }

    @Deprecated
    public CourierTemplateSpecGenerator(DataSchemaResolver dataSchemaResolver, String string) {
        this(dataSchemaResolver, string, "scala");
    }

    public CourierTemplateSpecGenerator(DataSchemaResolver dataSchemaResolver, String string, String string2) {
        this._schemaResolver = dataSchemaResolver;
        this._schemaParser = new SchemaParser(dataSchemaResolver);
        this._dataNamespace = string;
        this._customTypeLanguage = string2;
    }

    public DataSchemaLocation getClassLocation(ClassTemplateSpec classTemplateSpec) {
        return this._classToDataSchemaLocationMap.get(classTemplateSpec);
    }

    public void registerDefinedSchema(DataSchema dataSchema) {
        ClassTemplateSpec classTemplateSpec = this.createFromDataSchema(dataSchema);
        this._schemaToClassMap.put(dataSchema, classTemplateSpec);
        this._classNameToSchemaMap.put(classTemplateSpec.getFullName(), dataSchema);
    }

    public ClassTemplateSpec generate(DataSchema dataSchema) {
        return this.processSchema(dataSchema, null, null);
    }

    public ClassTemplateSpec generate(DataSchema dataSchema, DataSchemaLocation dataSchemaLocation) {
        this.pushCurrentLocation(dataSchemaLocation);
        ClassTemplateSpec classTemplateSpec = this.generate(dataSchema);
        this.popCurrentLocation();
        return classTemplateSpec;
    }

    public Collection<ClassTemplateSpec> getGeneratedSpecs() {
        return this._classTemplateSpecs;
    }

    private static void checkClassNameForSpecialSuffix(String string) {
        for (String string2 : SPECIAL_SUFFIXES) {
            if (!string.endsWith(string2)) continue;
            _log.warn("Class name for named type ends with a suffix that may conflict with derived class names for unnamed types, name: " + string + ", suffix: " + string2);
            break;
        }
    }

    private static boolean allowCustomClass(DataSchema dataSchema) {
        DataSchema dataSchema2;
        boolean bl = false;
        DataSchema.Type type = dataSchema.getType();
        if ((type == DataSchema.Type.TYPEREF || type == DataSchema.Type.RECORD) && ((dataSchema2 = dataSchema.getDereferencedDataSchema()).getType() == DataSchema.Type.RECORD || CodeUtil.isDirectType((DataSchema)dataSchema2) && dataSchema2.getType() != DataSchema.Type.ENUM)) {
            bl = true;
        }
        return bl;
    }

    private static DataSchema dereferenceIfTyperef(DataSchema dataSchema) {
        DataSchema.Type type = dataSchema.getType();
        return type == DataSchema.Type.TYPEREF ? ((TyperefDataSchema)dataSchema).getRef() : null;
    }

    private static IllegalArgumentException nullTypeNotAllowed(ClassTemplateSpec classTemplateSpec, String string) {
        return new IllegalArgumentException("The null type can only be used in unions, null found" + CourierTemplateSpecGenerator.enclosingClassAndMemberNameToString(classTemplateSpec, string));
    }

    private static IllegalStateException unrecognizedSchemaType(ClassTemplateSpec classTemplateSpec, String string, DataSchema dataSchema) {
        return new IllegalStateException("Unrecognized schema: " + dataSchema + CourierTemplateSpecGenerator.enclosingClassAndMemberNameToString(classTemplateSpec, string));
    }

    private static String enclosingClassAndMemberNameToString(ClassTemplateSpec classTemplateSpec, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(" in ");
            stringBuilder.append(string);
        }
        if (classTemplateSpec != null) {
            stringBuilder.append(" in ");
            stringBuilder.append(classTemplateSpec.getFullName());
        }
        return stringBuilder.toString();
    }

    private void checkForClassNameConflict(String string, DataSchema dataSchema) throws IllegalArgumentException {
        DataSchema dataSchema2 = this._classNameToSchemaMap.get(string);
        boolean bl = false;
        if (dataSchema2 != null && dataSchema2 != dataSchema) {
            DataSchema.Type type = dataSchema.getType();
            if (dataSchema2.getType() != type) {
                bl = true;
            } else if (dataSchema instanceof NamedDataSchema) {
                bl = true;
            } else if (!dataSchema2.equals((Object)dataSchema)) {
                assert (type == DataSchema.Type.ARRAY || type == DataSchema.Type.MAP);
                _log.info("Class name: " + string + ", bound to schema:" + dataSchema2 + ", instead of schema: " + dataSchema);
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Class name conflict detected, class name: " + string + ", class already bound to schema: " + dataSchema2 + ", attempting to rebind to schema: " + dataSchema);
        }
    }

    private DataSchemaLocation currentLocation() {
        return this._locationStack.getLast();
    }

    private void pushCurrentLocation(DataSchemaLocation dataSchemaLocation) {
        this._locationStack.addLast(dataSchemaLocation);
    }

    private void popCurrentLocation() {
        this._locationStack.removeLast();
    }

    private void registerClassTemplateSpec(DataSchema dataSchema, ClassTemplateSpec classTemplateSpec) {
        classTemplateSpec.setLocation(this.currentLocation().toString());
        this._schemaToClassMap.put(dataSchema, classTemplateSpec);
        this._classNameToSchemaMap.put(classTemplateSpec.getFullName(), dataSchema);
        this._classToDataSchemaLocationMap.put(classTemplateSpec, this.currentLocation());
        if (dataSchema instanceof NamedDataSchema) {
            CourierTemplateSpecGenerator.checkClassNameForSpecialSuffix(classTemplateSpec.getFullName());
        }
        this._classTemplateSpecs.add(classTemplateSpec);
    }

    private ClassTemplateSpec processSchema(DataSchema dataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        TyperefDataSchema typerefDataSchema;
        Object object = null;
        CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(dataSchema);
        while (dataSchema.getType() == DataSchema.Type.TYPEREF) {
            typerefDataSchema = (TyperefDataSchema)dataSchema;
            ClassTemplateSpec classTemplateSpec2 = this._schemaToClassMap.get(dataSchema);
            if (classTemplateSpec2 == null) {
                if (typerefDataSchema.getRef().getType() == DataSchema.Type.UNION) {
                    object = this.generateUnion((UnionDataSchema)typerefDataSchema.getRef(), typerefDataSchema);
                    break;
                }
                this.generateTyperef(typerefDataSchema);
            } else if (typerefDataSchema.getRef().getType() == DataSchema.Type.UNION) {
                object = classTemplateSpec2;
                break;
            }
            dataSchema = typerefDataSchema.getRef();
        }
        if (object == null) {
            assert (dataSchema == dataSchema.getDereferencedDataSchema());
            if (dataSchema instanceof ComplexDataSchema) {
                typerefDataSchema = this._schemaToClassMap.get(dataSchema);
                object = typerefDataSchema == null ? (dataSchema instanceof NamedDataSchema ? this.generateNamedSchema((NamedDataSchema)dataSchema) : this.generateUnnamedComplexSchema(dataSchema, classTemplateSpec, string)) : typerefDataSchema;
                if (customInfoSpec != null) {
                    object = customInfoSpec.getCustomClass();
                }
            } else if (dataSchema instanceof PrimitiveDataSchema) {
                ClassTemplateSpec classTemplateSpec3 = object = customInfoSpec != null ? customInfoSpec.getCustomClass() : this.getPrimitiveClassForSchema((PrimitiveDataSchema)dataSchema, classTemplateSpec, string);
            }
        }
        if (object == null) {
            throw CourierTemplateSpecGenerator.unrecognizedSchemaType(classTemplateSpec, string, dataSchema);
        }
        return object;
    }

    private CustomClasses getCustomClasses(DataSchema dataSchema) {
        Object v;
        CustomClasses customClasses = null;
        Map map = dataSchema.getProperties();
        if (this._customTypeLanguage != null && (v = map.get(this._customTypeLanguage)) != null) {
            Object object;
            if (v.getClass() != DataMap.class) {
                throw new IllegalArgumentException(dataSchema + " has \"java\" property that is not a DataMap");
            }
            DataMap dataMap = (DataMap)v;
            Object object2 = dataMap.get((Object)CLASS_PROPERTY);
            if (object2 != null) {
                if (object2.getClass() != String.class) {
                    throw new IllegalArgumentException(dataSchema + " has \"java\" property with \"class\" that is not a string");
                }
                customClasses = new CustomClasses();
                customClasses.customClass = new ClassTemplateSpec();
                customClasses.customClass.setFullName((String)object2);
                if (!CourierTemplateSpecGenerator.allowCustomClass(dataSchema)) {
                    throw new IllegalArgumentException(dataSchema + " cannot have custom class binding");
                }
            }
            if ((object = dataMap.get((Object)COERCER_CLASS_PROPERTY)) != null) {
                if (object.getClass() != String.class) {
                    throw new IllegalArgumentException(dataSchema + " has \"java\" property with \"coercerClass\" that is not a string");
                }
                if (customClasses == null) {
                    throw new IllegalArgumentException(dataSchema + " has \"java\" property with \"coercerClass\" but does not have \"class\" property");
                }
                customClasses.customCoercerClass = new ClassTemplateSpec();
                customClasses.customCoercerClass.setFullName((String)object);
            }
        }
        return customClasses;
    }

    private CustomInfoSpec getImmediateCustomInfo(DataSchema dataSchema) {
        if (this._immediateCustomMap.containsKey(dataSchema)) {
            return this._immediateCustomMap.get(dataSchema);
        }
        CustomInfoSpec customInfoSpec = null;
        DataSchema dataSchema2 = dataSchema;
        while (dataSchema2 != null) {
            CustomClasses customClasses = this.getCustomClasses(dataSchema2);
            if (customClasses != null) {
                customInfoSpec = new CustomInfoSpec((NamedDataSchema)dataSchema, (NamedDataSchema)dataSchema2, customClasses.customClass, customClasses.customCoercerClass);
                break;
            }
            dataSchema2 = CourierTemplateSpecGenerator.dereferenceIfTyperef(dataSchema2);
        }
        this._immediateCustomMap.put(dataSchema, customInfoSpec);
        return customInfoSpec;
    }

    private ClassTemplateSpec getPrimitiveClassForSchema(PrimitiveDataSchema primitiveDataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        switch (primitiveDataSchema.getType()) {
            case INT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: 
            case LONG: 
            case FLOAT: 
            case BYTES: {
                return PrimitiveTemplateSpec.getInstance((DataSchema.Type)primitiveDataSchema.getType());
            }
            case NULL: {
                throw CourierTemplateSpecGenerator.nullTypeNotAllowed(classTemplateSpec, string);
            }
        }
        throw CourierTemplateSpecGenerator.unrecognizedSchemaType(classTemplateSpec, string, (DataSchema)primitiveDataSchema);
    }

    private ClassTemplateSpec generateNamedSchema(NamedDataSchema namedDataSchema) {
        RecordTemplateSpec recordTemplateSpec;
        this.pushCurrentLocation((DataSchemaLocation)this._schemaResolver.nameToDataSchemaLocations().get(namedDataSchema.getFullName()));
        String string = CourierTemplateSpecGenerator.classNameForNamedSchema(namedDataSchema);
        this.checkForClassNameConflict(string, (DataSchema)namedDataSchema);
        switch (namedDataSchema.getType()) {
            case RECORD: {
                recordTemplateSpec = this.generateRecord((RecordDataSchema)namedDataSchema);
                break;
            }
            case ENUM: {
                recordTemplateSpec = this.generateEnum((EnumDataSchema)namedDataSchema);
                break;
            }
            case FIXED: {
                recordTemplateSpec = this.generateFixed((FixedDataSchema)namedDataSchema);
                break;
            }
            default: {
                throw CourierTemplateSpecGenerator.unrecognizedSchemaType(null, null, (DataSchema)namedDataSchema);
            }
        }
        this.popCurrentLocation();
        return recordTemplateSpec;
    }

    private ClassTemplateSpec generateUnnamedComplexSchema(DataSchema dataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        if (dataSchema instanceof ArrayDataSchema) {
            return this.generateArray((ArrayDataSchema)dataSchema, classTemplateSpec, string);
        }
        if (dataSchema instanceof MapDataSchema) {
            return this.generateMap((MapDataSchema)dataSchema, classTemplateSpec, string);
        }
        if (dataSchema instanceof UnionDataSchema) {
            return this.generateUnion((UnionDataSchema)dataSchema, classTemplateSpec, string);
        }
        throw CourierTemplateSpecGenerator.unrecognizedSchemaType(classTemplateSpec, string, dataSchema);
    }

    private ClassTemplateSpec determineDataClass(DataSchema dataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        DataSchema dataSchema2 = dataSchema.getDereferencedDataSchema();
        Object object = dataSchema2.getType() == DataSchema.Type.ENUM ? PrimitiveTemplateSpec.getInstance((DataSchema.Type)DataSchema.Type.STRING) : (CodeUtil.isDirectType((DataSchema)dataSchema2) ? this.getPrimitiveClassForSchema((PrimitiveDataSchema)dataSchema2, classTemplateSpec, string) : null);
        return object;
    }

    private ArrayTemplateSpec generateArray(ArrayDataSchema arrayDataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        DataSchema dataSchema = arrayDataSchema.getItems();
        ClassInfo classInfo = this.classInfoForUnnamed(classTemplateSpec, string, (DataSchema)arrayDataSchema);
        if (classInfo.existingClass != null) {
            this.processSchema(dataSchema, classTemplateSpec, string);
            return (ArrayTemplateSpec)classInfo.existingClass;
        }
        ArrayTemplateSpec arrayTemplateSpec = (ArrayTemplateSpec)classInfo.definedClass;
        this.registerClassTemplateSpec((DataSchema)arrayDataSchema, (ClassTemplateSpec)arrayTemplateSpec);
        arrayTemplateSpec.setItemClass(this.processSchema(dataSchema, classTemplateSpec, string));
        arrayTemplateSpec.setItemDataClass(this.determineDataClass(dataSchema, classTemplateSpec, string));
        CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(dataSchema);
        arrayTemplateSpec.setCustomInfo(customInfoSpec);
        return arrayTemplateSpec;
    }

    private CourierMapTemplateSpec generateMap(MapDataSchema mapDataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        DataSchema dataSchema = mapDataSchema.getValues();
        ClassInfo classInfo = this.classInfoForUnnamed(classTemplateSpec, string, (DataSchema)mapDataSchema);
        Object v = mapDataSchema.getProperties().get("keys");
        DataSchema dataSchema2 = v != null ? this._schemaParser.parseObject(v) : null;
        if (classInfo.existingClass != null) {
            this.processSchema(dataSchema, classTemplateSpec, string);
            if (dataSchema2 != null && classInfo.existingClass != null) {
                this.processSchema(dataSchema2, classTemplateSpec, string);
            }
            return (CourierMapTemplateSpec)classInfo.existingClass;
        }
        CourierMapTemplateSpec courierMapTemplateSpec = (CourierMapTemplateSpec)classInfo.definedClass;
        this.registerClassTemplateSpec((DataSchema)mapDataSchema, courierMapTemplateSpec);
        courierMapTemplateSpec.setValueClass(this.processSchema(dataSchema, classTemplateSpec, string));
        courierMapTemplateSpec.setValueDataClass(this.determineDataClass(dataSchema, classTemplateSpec, string));
        CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(dataSchema);
        courierMapTemplateSpec.setCustomInfo(customInfoSpec);
        if (dataSchema2 != null) {
            courierMapTemplateSpec.setKeySchema(dataSchema2);
            courierMapTemplateSpec.setKeyClass(this.processSchema(dataSchema2, classTemplateSpec, string));
            courierMapTemplateSpec.setKeyDataClass(this.determineDataClass(dataSchema2, classTemplateSpec, string));
            CustomInfoSpec customInfoSpec2 = this.getImmediateCustomInfo(dataSchema2);
            courierMapTemplateSpec.setKeyCustomInfo(customInfoSpec2);
        }
        return courierMapTemplateSpec;
    }

    private UnionTemplateSpec generateUnion(UnionDataSchema unionDataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        if (classTemplateSpec == null || string == null) {
            throw new IllegalArgumentException("Cannot processSchema template for top level union: " + unionDataSchema);
        }
        ClassInfo classInfo = this.classInfoForUnnamed(classTemplateSpec, string, (DataSchema)unionDataSchema);
        if (classInfo.existingClass != null) {
            return (UnionTemplateSpec)classInfo.existingClass;
        }
        UnionTemplateSpec unionTemplateSpec = (UnionTemplateSpec)classInfo.definedClass;
        this.registerClassTemplateSpec((DataSchema)unionDataSchema, (ClassTemplateSpec)unionTemplateSpec);
        return this.generateUnion(unionDataSchema, unionTemplateSpec);
    }

    private ClassTemplateSpec generateUnion(UnionDataSchema unionDataSchema, TyperefDataSchema typerefDataSchema) {
        assert (typerefDataSchema.getRef() == unionDataSchema);
        this.pushCurrentLocation((DataSchemaLocation)this._schemaResolver.nameToDataSchemaLocations().get(typerefDataSchema.getFullName()));
        UnionTemplateSpec unionTemplateSpec = new UnionTemplateSpec(unionDataSchema);
        unionTemplateSpec.setNamespace(typerefDataSchema.getNamespace());
        unionTemplateSpec.setClassName(typerefDataSchema.getName());
        unionTemplateSpec.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC});
        this.registerClassTemplateSpec((DataSchema)typerefDataSchema, (ClassTemplateSpec)unionTemplateSpec);
        TyperefTemplateSpec typerefTemplateSpec = new TyperefTemplateSpec(typerefDataSchema);
        typerefTemplateSpec.setEnclosingClass((ClassTemplateSpec)unionTemplateSpec);
        typerefTemplateSpec.setClassName("UnionTyperefInfo");
        typerefTemplateSpec.setModifiers(new ModifierSpec[]{ModifierSpec.PRIVATE, ModifierSpec.STATIC, ModifierSpec.FINAL});
        UnionTemplateSpec unionTemplateSpec2 = this.generateUnion(unionDataSchema, unionTemplateSpec);
        unionTemplateSpec2.setTyperefClass(typerefTemplateSpec);
        this.popCurrentLocation();
        return unionTemplateSpec2;
    }

    private UnionTemplateSpec generateUnion(UnionDataSchema unionDataSchema, UnionTemplateSpec unionTemplateSpec) {
        for (DataSchema dataSchema : unionDataSchema.getTypes()) {
            UnionTemplateSpec.Member member = new UnionTemplateSpec.Member();
            unionTemplateSpec.getMembers().add(member);
            member.setSchema(dataSchema);
            if (dataSchema.getDereferencedType() == DataSchema.Type.NULL) continue;
            member.setClassTemplateSpec(this.processSchema(dataSchema, (ClassTemplateSpec)unionTemplateSpec, dataSchema.getUnionMemberKey()));
            member.setDataClass(this.determineDataClass(dataSchema, (ClassTemplateSpec)unionTemplateSpec, dataSchema.getUnionMemberKey()));
        }
        return unionTemplateSpec;
    }

    private ClassTemplateSpec generateEnum(EnumDataSchema enumDataSchema) {
        EnumTemplateSpec enumTemplateSpec = new EnumTemplateSpec(enumDataSchema);
        enumTemplateSpec.setNamespace(enumDataSchema.getNamespace());
        enumTemplateSpec.setClassName(enumDataSchema.getName());
        enumTemplateSpec.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC});
        this.registerClassTemplateSpec((DataSchema)enumDataSchema, (ClassTemplateSpec)enumTemplateSpec);
        return enumTemplateSpec;
    }

    private ClassTemplateSpec generateFixed(FixedDataSchema fixedDataSchema) {
        FixedTemplateSpec fixedTemplateSpec = new FixedTemplateSpec(fixedDataSchema);
        fixedTemplateSpec.setNamespace(fixedDataSchema.getNamespace());
        fixedTemplateSpec.setClassName(fixedDataSchema.getName());
        fixedTemplateSpec.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC});
        this.registerClassTemplateSpec((DataSchema)fixedDataSchema, (ClassTemplateSpec)fixedTemplateSpec);
        return fixedTemplateSpec;
    }

    private TyperefTemplateSpec generateTyperef(TyperefDataSchema typerefDataSchema) {
        TyperefTemplateSpec typerefTemplateSpec = new TyperefTemplateSpec(typerefDataSchema);
        typerefTemplateSpec.setNamespace(typerefDataSchema.getNamespace());
        typerefTemplateSpec.setClassName(typerefDataSchema.getName());
        typerefTemplateSpec.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC});
        this.registerClassTemplateSpec((DataSchema)typerefDataSchema, (ClassTemplateSpec)typerefTemplateSpec);
        return typerefTemplateSpec;
    }

    private RecordTemplateSpec generateRecord(RecordDataSchema recordDataSchema) {
        RecordTemplateSpec recordTemplateSpec = new RecordTemplateSpec(recordDataSchema);
        recordTemplateSpec.setNamespace(recordDataSchema.getNamespace());
        recordTemplateSpec.setClassName(recordDataSchema.getName());
        recordTemplateSpec.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC});
        this.registerClassTemplateSpec((DataSchema)recordDataSchema, (ClassTemplateSpec)recordTemplateSpec);
        List list = recordDataSchema.getInclude();
        for (Object object : list) {
            this.generate((DataSchema)object);
        }
        IdentityHashMap identityHashMap = new IdentityHashMap(recordDataSchema.getFields().size() * 2);
        for (RecordDataSchema.Field field : recordDataSchema.getFields()) {
            ClassTemplateSpec classTemplateSpec = this.processSchema(field.getType(), (ClassTemplateSpec)recordTemplateSpec, field.getName());
            RecordTemplateSpec.Field field2 = new RecordTemplateSpec.Field();
            field2.setSchemaField(field);
            field2.setType(classTemplateSpec);
            field2.setDataClass(this.determineDataClass(field.getType(), (ClassTemplateSpec)recordTemplateSpec, field.getName()));
            CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(field.getType());
            if (customInfoSpec != null && !identityHashMap.containsKey(customInfoSpec)) {
                identityHashMap.put(customInfoSpec, null);
                field2.setCustomInfo(customInfoSpec);
            }
            recordTemplateSpec.addField(field2);
        }
        return recordTemplateSpec;
    }

    private ClassInfo classInfoForUnnamed(ClassTemplateSpec classTemplateSpec, String string, DataSchema dataSchema) {
        assert (!(dataSchema instanceof NamedDataSchema));
        assert (!(dataSchema instanceof PrimitiveDataSchema));
        ClassInfo classInfo = this.classNameForUnnamedTraverse(classTemplateSpec, string, dataSchema);
        String string2 = classInfo.fullName();
        DataSchema dataSchema2 = this._classNameToSchemaMap.get(string2);
        if (dataSchema2 == null) {
            ClassTemplateSpec classTemplateSpec2 = this.createFromDataSchema(dataSchema);
            if (classTemplateSpec != null && classInfo.namespace.equals(classTemplateSpec.getFullName())) {
                classTemplateSpec2.setEnclosingClass(classTemplateSpec);
                classTemplateSpec2.setClassName(classInfo.name);
                classTemplateSpec2.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC, ModifierSpec.STATIC, ModifierSpec.FINAL});
            } else {
                classTemplateSpec2.setNamespace(classInfo.namespace);
                classTemplateSpec2.setClassName(classInfo.name);
                classTemplateSpec2.setModifiers(new ModifierSpec[]{ModifierSpec.PUBLIC});
            }
            classInfo.definedClass = classTemplateSpec2;
        } else {
            this.checkForClassNameConflict(string2, dataSchema);
            classInfo.existingClass = this._schemaToClassMap.get(dataSchema2);
        }
        return classInfo;
    }

    private ClassTemplateSpec createFromDataSchema(DataSchema dataSchema) {
        if (dataSchema instanceof MapDataSchema) {
            return new CourierMapTemplateSpec((MapDataSchema)dataSchema);
        }
        return ClassTemplateSpec.createFromDataSchema((DataSchema)dataSchema);
    }

    private ClassInfo classNameForUnnamedTraverse(ClassTemplateSpec classTemplateSpec, String string, DataSchema dataSchema) {
        DataSchema dataSchema2 = dataSchema.getDereferencedDataSchema();
        switch (dataSchema2.getType()) {
            case ARRAY: {
                ArrayDataSchema arrayDataSchema = (ArrayDataSchema)dataSchema2;
                CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(arrayDataSchema.getItems());
                if (customInfoSpec != null) {
                    return new ClassInfo(customInfoSpec.getCustomSchema().getNamespace(), customInfoSpec.getCustomSchema().getName() + ARRAY_SUFFIX);
                }
                ClassInfo classInfo = this.classNameForUnnamedTraverse(classTemplateSpec, string, arrayDataSchema.getItems());
                classInfo.name = classInfo.name + ARRAY_SUFFIX;
                return classInfo;
            }
            case MAP: {
                MapDataSchema mapDataSchema = (MapDataSchema)dataSchema2;
                ClassAndSchema classAndSchema = this.getMapKeyName(mapDataSchema, classTemplateSpec, string);
                ClassAndSchema classAndSchema2 = this.getMapValueName(mapDataSchema, classTemplateSpec, string);
                String string2 = classAndSchema != null ? classAndSchema.classInfo.name + "To" + classAndSchema2.classInfo.name + MAP_SUFFIX : classAndSchema2.classInfo.name + MAP_SUFFIX;
                String string3 = classAndSchema2.schema instanceof PrimitiveDataSchema ? (classAndSchema != null && !(classAndSchema.schema instanceof PrimitiveDataSchema) ? classAndSchema.classInfo.namespace : this._dataNamespace) : classAndSchema2.classInfo.namespace;
                return new ClassInfo(string3, string2);
            }
            case UNION: {
                if (dataSchema.getType() == DataSchema.Type.TYPEREF) {
                    DataSchema dataSchema3;
                    TyperefDataSchema typerefDataSchema = (TyperefDataSchema)dataSchema;
                    while ((dataSchema3 = typerefDataSchema.getDereferencedDataSchema()) != dataSchema2) {
                        typerefDataSchema = (TyperefDataSchema)dataSchema3;
                    }
                    return new ClassInfo(typerefDataSchema.getNamespace(), CodeUtil.capitalize((String)typerefDataSchema.getName()));
                }
                return new ClassInfo(classTemplateSpec.getFullName(), CodeUtil.capitalize((String)string));
            }
            case RECORD: 
            case ENUM: 
            case FIXED: {
                NamedDataSchema namedDataSchema = (NamedDataSchema)dataSchema2;
                return new ClassInfo(namedDataSchema.getNamespace(), CodeUtil.capitalize((String)namedDataSchema.getName()));
            }
            case BOOLEAN: {
                return new ClassInfo("org.coursera.courier.data", "Boolean");
            }
            case INT: {
                return new ClassInfo("org.coursera.courier.data", "Int");
            }
            case LONG: {
                return new ClassInfo("org.coursera.courier.data", "Long");
            }
            case FLOAT: {
                return new ClassInfo("org.coursera.courier.data", "Float");
            }
            case DOUBLE: {
                return new ClassInfo("org.coursera.courier.data", "Double");
            }
            case STRING: {
                return new ClassInfo("org.coursera.courier.data", "String");
            }
            case BYTES: {
                return new ClassInfo("org.coursera.courier.data", "ByteString");
            }
            case NULL: {
                throw CourierTemplateSpecGenerator.nullTypeNotAllowed(classTemplateSpec, string);
            }
        }
        throw CourierTemplateSpecGenerator.unrecognizedSchemaType(classTemplateSpec, string, dataSchema2);
    }

    private ClassAndSchema getMapKeyName(MapDataSchema mapDataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        Object v = mapDataSchema.getProperties().get("keys");
        if (v != null) {
            DataSchema dataSchema = this._schemaParser.parseObject(v);
            ClassInfo classInfo = this.classNameForUnnamedTraverse(classTemplateSpec, string, dataSchema);
            CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(dataSchema);
            if (customInfoSpec != null) {
                NamedDataSchema namedDataSchema = customInfoSpec.getCustomSchema();
                return new ClassAndSchema(new ClassInfo(namedDataSchema.getNamespace(), namedDataSchema.getName()), (DataSchema)namedDataSchema);
            }
            if (classInfo.name.equals("String")) {
                return null;
            }
            return new ClassAndSchema(classInfo, dataSchema);
        }
        return null;
    }

    private ClassAndSchema getMapValueName(MapDataSchema mapDataSchema, ClassTemplateSpec classTemplateSpec, String string) {
        CustomInfoSpec customInfoSpec = this.getImmediateCustomInfo(mapDataSchema.getValues());
        if (customInfoSpec != null) {
            return new ClassAndSchema(new ClassInfo(customInfoSpec.getCustomSchema().getNamespace(), customInfoSpec.getCustomSchema().getName()), (DataSchema)customInfoSpec.getCustomSchema());
        }
        return new ClassAndSchema(this.classNameForUnnamedTraverse(classTemplateSpec, string, mapDataSchema.getValues()), mapDataSchema.getValues());
    }

    private static class ClassInfo {
        private String namespace;
        private String name;
        private ClassTemplateSpec existingClass;
        private ClassTemplateSpec definedClass;

        private ClassInfo(String string, String string2) {
            this.namespace = string;
            this.name = string2;
        }

        private String fullName() {
            return this.namespace.isEmpty() ? this.name : this.namespace + '.' + this.name;
        }
    }

    private static class CustomClasses {
        private ClassTemplateSpec customClass;
        private ClassTemplateSpec customCoercerClass;

        private CustomClasses() {
        }
    }

    private static class ClassAndSchema {
        private ClassInfo classInfo;
        private DataSchema schema;

        private ClassAndSchema(ClassInfo classInfo, DataSchema dataSchema) {
            this.classInfo = classInfo;
            this.schema = dataSchema;
        }
    }
}

