/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.pegasus.generator.DefaultGeneratorResult;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coursera.courier.api.ClassTemplateSpecs;
import org.coursera.courier.api.CourierTemplateSpecGenerator;
import org.coursera.courier.api.GeneratedCode;
import org.coursera.courier.api.GeneratedCodeTargetFile;
import org.coursera.courier.api.GeneratorRunner;
import org.coursera.courier.api.GeneratorRunnerOptions;
import org.coursera.courier.api.PegasusCodeGenerator;

public class DefaultGeneratorRunner
implements GeneratorRunner {
    @Override
    public GeneratorResult run(PegasusCodeGenerator pegasusCodeGenerator, GeneratorRunnerOptions generatorRunnerOptions) throws IOException {
        GeneratedCode generatedCode;
        Object object3;
        Object object22;
        DataSchemaParser dataSchemaParser = new DataSchemaParser(generatorRunnerOptions.getResolverPath());
        CourierTemplateSpecGenerator courierTemplateSpecGenerator = new CourierTemplateSpecGenerator(dataSchemaParser.getSchemaResolver(), generatorRunnerOptions.getDataNamespace(), pegasusCodeGenerator.customTypeLanguage());
        File file = new File(generatorRunnerOptions.getTargetDirectoryPath());
        file.delete();
        file.mkdirs();
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("unable to create directory, or directory path exists but is not a directory: " + file.getAbsolutePath());
        }
        for (DataSchema object42 : pegasusCodeGenerator.definedSchemas()) {
            courierTemplateSpecGenerator.registerDefinedSchema(object42);
        }
        DataSchemaParser.ParseResult parseResult = dataSchemaParser.parseSources(generatorRunnerOptions.getSources());
        for (Object object22 : parseResult.getSchemaAndFiles()) {
            FileDataSchemaLocation fileDataSchemaLocation = new FileDataSchemaLocation((File)((CodeUtil.Pair)object22).second);
            courierTemplateSpecGenerator.generate((DataSchema)((CodeUtil.Pair)object22).first, (DataSchemaLocation)fileDataSchemaLocation);
        }
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>();
        for (ClassTemplateSpec classTemplateSpec : courierTemplateSpecGenerator.getGeneratedSpecs()) {
            hashSet.addAll(DefaultGeneratorRunner.findTopLevelTypes(classTemplateSpec));
        }
        if (generatorRunnerOptions.isGeneratePredef()) {
            object22 = pegasusCodeGenerator.generatePredef();
        } else {
            object22 = new HashSet();
            for (Object object3 : hashSet) {
                generatedCode = pegasusCodeGenerator.generate((ClassTemplateSpec)object3);
                if (generatedCode == null) continue;
                object22.add(generatedCode);
            }
        }
        HashSet<File> hashSet2 = new HashSet<File>();
        object3 = object22.iterator();
        while (object3.hasNext()) {
            generatedCode = (GeneratedCode)object3.next();
            hashSet2.add(DefaultGeneratorRunner.writeCode(file, generatedCode));
        }
        object3 = hashSet2;
        return new DefaultGeneratorResult((Collection)parseResult.getSourceFiles(), hashSet2, (Collection)object3);
    }

    private static Set<ClassTemplateSpec> findTopLevelTypes(ClassTemplateSpec classTemplateSpec) {
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>(ClassTemplateSpecs.allReferencedTypes(classTemplateSpec));
        hashSet.add(classTemplateSpec);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ClassTemplateSpec classTemplateSpec2 = (ClassTemplateSpec)iterator.next();
            if (classTemplateSpec2.getEnclosingClass() == null) continue;
            iterator.remove();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeCode(File file, GeneratedCode generatedCode) throws IOException {
        GeneratedCodeTargetFile generatedCodeTargetFile = generatedCode.getTarget();
        File file2 = generatedCodeTargetFile.toFile(file);
        File file3 = file2.getParentFile();
        file3.mkdirs();
        if (!file3.exists() || !file3.isDirectory()) {
            throw new IllegalArgumentException("unable to create directory, or directory path exists but is not a directory: " + file3.getAbsolutePath());
        }
        if (!file2.exists() && !file2.createNewFile()) {
            throw new IllegalArgumentException("unable to create file: " + file2.getAbsolutePath());
        }
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));){
            printWriter.write(generatedCode.getCode());
        }
        return file2;
    }
}

