/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.pegasus.generator.DefaultGeneratorResult;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.coursera.courier.api.ClassTemplateSpecs;
import org.coursera.courier.api.CourierTemplateSpecGenerator;
import org.coursera.courier.api.GeneratedCode;
import org.coursera.courier.api.GeneratedCodeTargetFile;
import org.coursera.courier.api.GeneratorRunner;
import org.coursera.courier.api.GeneratorRunnerOptions;
import org.coursera.courier.api.MultiFormatSchemaParser;
import org.coursera.courier.api.PegasusCodeGenerator;

public class DefaultGeneratorRunner
implements GeneratorRunner {
    /*
     * WARNING - void declaration
     */
    @Override
    public GeneratorResult run(PegasusCodeGenerator pegasusCodeGenerator, GeneratorRunnerOptions generatorRunnerOptions) throws IOException {
        void var8_15;
        Object object2;
        MultiFormatSchemaParser multiFormatSchemaParser = new MultiFormatSchemaParser(generatorRunnerOptions.getResolverPath(), generatorRunnerOptions.getParsersForFileFormats());
        CourierTemplateSpecGenerator courierTemplateSpecGenerator = new CourierTemplateSpecGenerator(multiFormatSchemaParser.getSchemaResolver(), generatorRunnerOptions.getDataNamespace(), pegasusCodeGenerator.customTypeLanguage());
        File file = new File(generatorRunnerOptions.getTargetDirectoryPath());
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException iOException) {
            throw new IOException("Unable to create targetDirectory, or directory path exists but is not a directory: " + file.getAbsolutePath(), iOException);
        }
        for (DataSchema object32 : pegasusCodeGenerator.definedSchemas()) {
            courierTemplateSpecGenerator.registerDefinedSchema(object32);
        }
        DataSchemaParser.ParseResult parseResult = multiFormatSchemaParser.parseSources(generatorRunnerOptions.getSources());
        for (Map.Entry entry : parseResult.getSchemaAndLocations().entrySet()) {
            courierTemplateSpecGenerator.generate((DataSchema)entry.getKey(), (DataSchemaLocation)entry.getValue());
        }
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>();
        for (ClassTemplateSpec classTemplateSpec : courierTemplateSpecGenerator.getGeneratedSpecs()) {
            hashSet.addAll(DefaultGeneratorRunner.findTopLevelTypes(classTemplateSpec));
        }
        if (generatorRunnerOptions.isGeneratePredef()) {
            Collection<GeneratedCode> collection = pegasusCodeGenerator.generatePredef();
        } else {
            HashSet<GeneratedCode> hashSet2 = new HashSet<GeneratedCode>();
            for (Object object2 : hashSet) {
                GeneratedCode generatedCode = pegasusCodeGenerator.generate((ClassTemplateSpec)object2);
                if (generatedCode == null) continue;
                hashSet2.add(generatedCode);
            }
        }
        HashSet<File> hashSet3 = new HashSet<File>();
        for (GeneratedCode generatedCode : var8_15) {
            hashSet3.add(DefaultGeneratorRunner.writeCode(file, generatedCode));
        }
        try {
            this.deleteUnrecognizedFiles(file, hashSet3);
        }
        catch (IOException iOException) {
            throw new IOException("Unexpected error while clearing unused files from targetDirectory:" + file.getAbsolutePath(), iOException);
        }
        object2 = hashSet3;
        return new DefaultGeneratorResult((Collection)parseResult.getSourceFiles(), hashSet3, (Collection)object2);
    }

    private void deleteUnrecognizedFiles(File file, Collection<File> collection) throws IOException {
        Collection collection2 = FileUtils.listFiles((File)file, null, (boolean)true);
        for (File file2 : collection2) {
            if (collection.contains(file2)) continue;
            FileUtils.forceDelete((File)file2);
        }
    }

    private static Set<ClassTemplateSpec> findTopLevelTypes(ClassTemplateSpec classTemplateSpec) {
        HashSet<ClassTemplateSpec> hashSet = new HashSet<ClassTemplateSpec>(ClassTemplateSpecs.allReferencedTypes(classTemplateSpec));
        hashSet.add(classTemplateSpec);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ClassTemplateSpec classTemplateSpec2 = (ClassTemplateSpec)iterator.next();
            if (classTemplateSpec2.getEnclosingClass() == null) continue;
            iterator.remove();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeCode(File file, GeneratedCode generatedCode) throws IOException {
        GeneratedCodeTargetFile generatedCodeTargetFile = generatedCode.getTarget();
        File file2 = generatedCodeTargetFile.toFile(file);
        File file3 = file2.getParentFile();
        file3.mkdirs();
        if (!file3.exists() || !file3.isDirectory()) {
            throw new IllegalArgumentException("unable to create directory, or directory path exists but is not a directory: " + file3.getAbsolutePath());
        }
        if (!file2.exists() && !file2.createNewFile()) {
            throw new IllegalArgumentException("unable to create file: " + file2.getAbsolutePath());
        }
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));){
            printWriter.write(generatedCode.getCode());
        }
        return file2;
    }
}

