/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.resolver.FileDataSchemaResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coursera.courier.api.ParserForFileFormat;
import org.coursera.courier.api.ResolverOverrideSchemaParserFactory;

public class MultiFormatDataSchemaResolver
implements DataSchemaResolver {
    private final Map<String, DataSchemaResolver> resolversByExtension = new HashMap<String, DataSchemaResolver>();
    private final List<DataSchemaResolver> resolvers = new ArrayList<DataSchemaResolver>();

    public MultiFormatDataSchemaResolver(String string, List<ParserForFileFormat> list) {
        for (ParserForFileFormat parserForFileFormat : list) {
            ResolverOverrideSchemaParserFactory resolverOverrideSchemaParserFactory = new ResolverOverrideSchemaParserFactory(parserForFileFormat.parserFactory, this);
            FileDataSchemaResolver fileDataSchemaResolver = new FileDataSchemaResolver((SchemaParserFactory)resolverOverrideSchemaParserFactory, string);
            fileDataSchemaResolver.setExtension("." + parserForFileFormat.fileExtension);
            this.resolversByExtension.put(parserForFileFormat.fileExtension, (DataSchemaResolver)fileDataSchemaResolver);
            this.resolvers.add((DataSchemaResolver)fileDataSchemaResolver);
        }
    }

    public Map<String, NamedDataSchema> bindings() {
        HashMap<String, NamedDataSchema> hashMap = new HashMap<String, NamedDataSchema>();
        for (DataSchemaResolver dataSchemaResolver : this.resolvers) {
            hashMap.putAll(dataSchemaResolver.bindings());
        }
        return hashMap;
    }

    public Map<String, DataSchemaLocation> nameToDataSchemaLocations() {
        HashMap<String, DataSchemaLocation> hashMap = new HashMap<String, DataSchemaLocation>();
        for (DataSchemaResolver dataSchemaResolver : this.resolvers) {
            hashMap.putAll(dataSchemaResolver.nameToDataSchemaLocations());
        }
        return hashMap;
    }

    public NamedDataSchema findDataSchema(String string, StringBuilder stringBuilder) {
        for (DataSchemaResolver dataSchemaResolver : this.resolvers) {
            NamedDataSchema namedDataSchema = dataSchemaResolver.findDataSchema(string, stringBuilder);
            if (namedDataSchema == null) continue;
            return namedDataSchema;
        }
        return null;
    }

    public void bindNameToSchema(Name name, NamedDataSchema namedDataSchema, DataSchemaLocation dataSchemaLocation) {
        for (DataSchemaResolver dataSchemaResolver : this.resolvers) {
            dataSchemaResolver.bindNameToSchema(name, namedDataSchema, dataSchemaLocation);
        }
    }

    public NamedDataSchema existingDataSchema(String string) {
        for (DataSchemaResolver dataSchemaResolver : this.resolvers) {
            NamedDataSchema namedDataSchema = dataSchemaResolver.existingDataSchema(string);
            if (namedDataSchema == null) continue;
            return namedDataSchema;
        }
        return null;
    }

    public boolean locationResolved(DataSchemaLocation dataSchemaLocation) {
        for (DataSchemaResolver dataSchemaResolver : this.resolvers) {
            if (!dataSchemaResolver.locationResolved(dataSchemaLocation)) continue;
            return true;
        }
        return false;
    }
}

