/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.courier.api;

import com.linkedin.data.schema.SchemaParserFactory;
import java.util.ArrayList;
import java.util.List;
import org.coursera.courier.api.ParserForFileFormat;
import org.coursera.courier.grammar.CourierSchemaParserFactory;

public class GeneratorRunnerOptions {
    private String resolverPath;
    private String targetDirectoryPath;
    private String[] sources;
    private String defaultPackage = "";
    private String dataNamespace = "org.coursera.courier.data";
    private boolean generateImported = false;
    private boolean generateTyperefs = false;
    private boolean generatePredef = false;
    private final List<ParserForFileFormat> parsersForFileFormats;

    public GeneratorRunnerOptions(String string, String[] stringArray, String string2) {
        this.targetDirectoryPath = string;
        this.sources = stringArray;
        this.resolverPath = string2;
        this.parsersForFileFormats = new ArrayList<ParserForFileFormat>();
        this.parsersForFileFormats.add(new ParserForFileFormat("pdsc", SchemaParserFactory.instance()));
        this.parsersForFileFormats.add(new ParserForFileFormat("courier", (SchemaParserFactory)new CourierSchemaParserFactory()));
    }

    public GeneratorRunnerOptions setDefaultPackage(String string) {
        this.defaultPackage = string;
        return this;
    }

    public GeneratorRunnerOptions setDataNamespace(String string) {
        this.dataNamespace = string;
        return this;
    }

    public GeneratorRunnerOptions setGenerateImported(boolean bl) {
        this.generateImported = bl;
        return this;
    }

    public GeneratorRunnerOptions setGenerateTyperefs(boolean bl) {
        this.generateTyperefs = bl;
        return this;
    }

    public GeneratorRunnerOptions setGeneratePredef(boolean bl) {
        this.generatePredef = bl;
        return this;
    }

    public GeneratorRunnerOptions addParserForFileFormat(ParserForFileFormat parserForFileFormat) {
        this.parsersForFileFormats.add(parserForFileFormat);
        return this;
    }

    public String getResolverPath() {
        return this.resolverPath;
    }

    public String getTargetDirectoryPath() {
        return this.targetDirectoryPath;
    }

    public String[] getSources() {
        return this.sources;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public String getDataNamespace() {
        return this.dataNamespace;
    }

    public boolean isGenerateImported() {
        return this.generateImported;
    }

    public boolean isGenerateTyperefs() {
        return this.generateTyperefs;
    }

    public boolean isGeneratePredef() {
        return this.generatePredef;
    }

    public List<ParserForFileFormat> getParsersForFileFormats() {
        return this.parsersForFileFormats;
    }
}

